/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.api.machine.MachineTile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="custommachinery")
public class MachineList {
    private static final List<WeakReference<MachineTile>> LOADED_MACHINES = Collections.synchronizedList(new ArrayList());
    private static boolean needRefresh = false;

    public static void addMachine(MachineTile tile) {
        if (tile.getLevel() != null && !tile.getLevel().isClientSide()) {
            LOADED_MACHINES.add(new WeakReference<MachineTile>(tile));
        }
    }

    public static void refreshAllMachines() {
        MachineList.getLoadedMachines().forEach(tile -> tile.refreshMachine(null));
    }

    public static void setNeedRefresh() {
        needRefresh = true;
    }

    public static Optional<MachineTile> findNearest(Player player, @Nullable ResourceLocation machine, int radius) {
        return MachineList.getLoadedMachines().stream().filter(tile -> tile.getLevel() == player.level() && tile.getBlockPos().closerThan((Vec3i)player.blockPosition(), (double)radius) && (machine == null || machine.equals((Object)tile.getMachine().getId()))).min(Comparator.comparingInt(tile -> tile.getBlockPos().distManhattan((Vec3i)player.blockPosition())));
    }

    public static Optional<MachineTile> findInSameChunk(MachineTile machine) {
        return MachineList.getLoadedMachines().stream().filter(tile -> tile != machine && tile.getLevel() == machine.getLevel() && new ChunkPos(tile.getBlockPos()).equals((Object)new ChunkPos(machine.getBlockPos()))).findFirst();
    }

    public static List<MachineTile> getLoadedMachines() {
        Iterator<WeakReference<MachineTile>> iterator = LOADED_MACHINES.iterator();
        ArrayList<MachineTile> loadedMachines = new ArrayList<MachineTile>();
        while (iterator.hasNext()) {
            MachineTile tile = (MachineTile)((Object)iterator.next().get());
            if (tile == null || tile.isRemoved()) {
                iterator.remove();
                continue;
            }
            loadedMachines.add(tile);
        }
        return loadedMachines;
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        if (needRefresh && event.hasTime()) {
            needRefresh = false;
            MachineList.refreshAllMachines();
        }
    }
}

