/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.sound;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import fr.frinn.custommachinery.impl.codec.NamedRecordCodec;
import java.util.function.Function;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import org.apache.commons.lang3.StringUtils;

public class CMSoundType
extends SoundType {
    public static final CMSoundType DEFAULT = new CMSoundType(new PartialBlockState(Blocks.IRON_BLOCK));
    public static final NamedCodec<CMSoundType> FROM_STATE = PartialBlockState.CODEC.xmap(CMSoundType::new, type -> type.defaultBlock, "Sound type");
    public static final NamedMapCodec<CMSoundType> FROM_PARTS = NamedCodec.record(cmSoundTypeInstance -> cmSoundTypeInstance.group(NamedCodec.FLOAT.optionalFieldOf("volume", Float.valueOf(1.0f)).forGetter(SoundType::getVolume), NamedCodec.FLOAT.optionalFieldOf("pitch", Float.valueOf(1.0f)).forGetter(SoundType::getPitch), CMSoundType.partCodec("break", SoundType::getBreakSound), CMSoundType.partCodec("step", SoundType::getStepSound), CMSoundType.partCodec("place", SoundType::getPlaceSound), CMSoundType.partCodec("hit", SoundType::getHitSound), CMSoundType.partCodec("fall", SoundType::getFallSound)).apply((Applicative)cmSoundTypeInstance, CMSoundType::new), "Sound type");
    public static final NamedCodec<CMSoundType> CODEC = NamedCodec.either(FROM_STATE, FROM_PARTS, "Interaction sounds").xmap(either -> (CMSoundType)((Object)((Object)either.map(Function.identity(), Function.identity()))), Either::right, "Interaction sounds");
    private final PartialBlockState defaultBlock;

    public CMSoundType(float volume, float pitch, SoundEvent breakSound, SoundEvent stepSound, SoundEvent placeSound, SoundEvent hitSound, SoundEvent fallSound) {
        super(volume, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
        this.defaultBlock = PartialBlockState.AIR;
    }

    public CMSoundType(PartialBlockState state) {
        super(1.0f, 1.0f, state.getBlockState().getSoundType().getBreakSound(), state.getBlockState().getSoundType().getStepSound(), state.getBlockState().getSoundType().getPlaceSound(), state.getBlockState().getSoundType().getHitSound(), state.getBlockState().getSoundType().getFallSound());
        this.defaultBlock = state;
    }

    private static NamedRecordCodec<CMSoundType, SoundEvent> partCodec(String field, Function<SoundType, SoundEvent> typeToSound) {
        return NamedCodec.either(PartialBlockState.CODEC, DefaultCodecs.SOUND_EVENT, StringUtils.capitalize((String)field) + " Sound").xmap(either -> (SoundEvent)either.map(state -> (SoundEvent)typeToSound.apply(state.getBlockState().getSoundType()), Function.identity()), Either::right, StringUtils.capitalize((String)field) + " Sound").optionalFieldOf(field, typeToSound.apply(DEFAULT)).forGetter(typeToSound::apply);
    }
}

