/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class FieldCodec<A>
extends NamedMapCodec<A> {
    private final String fieldName;
    private final NamedCodec<A> elementCodec;
    private final String name;

    public static <A> NamedMapCodec<A> of(String fieldName, NamedCodec<A> elementCodec, String name) {
        return new FieldCodec<A>(fieldName, elementCodec, name);
    }

    protected FieldCodec(String fieldName, NamedCodec<A> elementCodec, String name) {
        this.fieldName = FieldCodec.toSnakeCase(fieldName);
        this.elementCodec = elementCodec;
        this.name = name;
    }

    @Override
    public FieldCodec<A> aliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    @Override
    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = FieldCodec.tryGetValue(ops, input, this.fieldName);
        if (value == null) {
            String alias;
            Iterator iterator = this.aliases.iterator();
            while (iterator.hasNext() && (value = input.get(alias = (String)iterator.next())) == null) {
            }
        }
        if (value == null) {
            ICustomMachineryAPI.INSTANCE.logger().error("Missing mandatory property \"{}\" of type \"{}\" in {}", (Object)this.fieldName, (Object)this.name, input);
            return DataResult.error(() -> "No key " + this.fieldName + " in " + String.valueOf(input));
        }
        return this.elementCodec.read(ops, value);
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return prefix.add(this.fieldName, this.elementCodec.encodeStart(ops, input));
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.fieldName));
    }

    @Override
    public String name() {
        return this.name;
    }

    public static String toSnakeCase(String input) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (char c : input.toCharArray()) {
            if (c == ' ') {
                builder.append('_');
            } else if (Character.isUpperCase(c)) {
                if (index != 0) {
                    builder.append('_');
                }
                builder.append(String.valueOf(c).toLowerCase(Locale.ROOT));
            } else {
                builder.append(c);
            }
            ++index;
        }
        return builder.toString();
    }

    @Nullable
    public static <T> T tryGetValue(DynamicOps<T> ops, MapLike<T> map, String fieldName) {
        return map.entries().filter(pair -> {
            String key = (String)ops.getStringValue(pair.getFirst()).result().orElseThrow();
            return key.equals(fieldName) || FieldCodec.toSnakeCase(key).equals(fieldName) || FieldCodec.toSnakeCase(key).replace("_", "").equals(fieldName.replace("_", ""));
        }).findFirst().map(Pair::getSecond).orElse(null);
    }
}

