/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.ProcessorType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class RegistrarCodec<V>
implements NamedCodec<V> {
    public static final NamedCodec<Item> ITEM = RegistrarCodec.of(BuiltInRegistries.ITEM, false);
    public static final NamedCodec<Block> BLOCK = RegistrarCodec.of(BuiltInRegistries.BLOCK, false);
    public static final NamedCodec<Fluid> FLUID = RegistrarCodec.of(BuiltInRegistries.FLUID, false);
    public static final NamedCodec<EntityType<?>> ENTITY = RegistrarCodec.of(BuiltInRegistries.ENTITY_TYPE, false);
    public static final NamedCodec<MobEffect> EFFECT = RegistrarCodec.of(BuiltInRegistries.MOB_EFFECT, false);
    public static final NamedCodec<MachineComponentType<?>> MACHINE_COMPONENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.componentRegistrar(), true);
    public static final NamedCodec<RequirementType<?>> REQUIREMENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.requirementRegistrar(), true);
    public static final NamedCodec<GuiElementType<?>> GUI_ELEMENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.guiElementRegistrar(), true);
    public static final NamedCodec<MachineAppearanceProperty<?>> APPEARANCE_PROPERTY = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.appearancePropertyRegistrar(), true);
    public static final NamedCodec<DataType<?, ?>> DATA = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.dataRegistrar(), true);
    public static final NamedCodec<ProcessorType<?>> CRAFTING_PROCESSOR = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.processorRegistrar(), true);
    public static final NamedCodec<ResourceLocation> CM_LOC_CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            if (s.contains(":")) {
                return DataResult.success((Object)ResourceLocation.parse((String)s));
            }
            return DataResult.success((Object)ResourceLocation.fromNamespaceAndPath((String)ICustomMachineryAPI.INSTANCE.modid(), (String)s));
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }, ResourceLocation::toString, "CM Resource location");
    private final Registry<V> registrar;
    private final boolean isCM;

    public static <V> RegistrarCodec<V> of(Registry<V> registrar, boolean isCM) {
        return new RegistrarCodec<V>(registrar, isCM);
    }

    private RegistrarCodec(Registry<V> registrar, boolean isCM) {
        this.registrar = registrar;
        this.isCM = isCM;
    }

    @Override
    public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
        return (this.isCM ? CM_LOC_CODEC : DefaultCodecs.RESOURCE_LOCATION).decode(ops, input).flatMap(keyValuePair -> !this.registrar.containsKey((ResourceLocation)keyValuePair.getFirst()) ? DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.registrar.key()) + ": " + String.valueOf(keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> this.registrar.get(arg_0))));
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, V input, T prefix) {
        return DefaultCodecs.RESOURCE_LOCATION.encode(ops, this.registrar.getKey(input), prefix);
    }

    @Override
    public String name() {
        return this.registrar.key().location().toString();
    }
}

