/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.screen.creation.component;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.utils.Filter;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentConfigBuilderWidget;
import fr.frinn.custommachinery.client.screen.creation.component.FilterConfigPopup;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public class ChemicalComponentBuilder
implements IMachineComponentBuilder<ChemicalMachineComponent, ChemicalMachineComponent.Template> {
    public MachineComponentType<ChemicalMachineComponent> type() {
        return Registration.CHEMICAL_MACHINE_COMPONENT.get();
    }

    public PopupScreen makePopup(MachineEditScreen parent, @Nullable ChemicalMachineComponent.Template template, Consumer<ChemicalMachineComponent.Template> onFinish) {
        return new ChemicalComponentBuilderPopup((BaseScreen)parent, template, onFinish, (Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.chemical.title"));
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height, ChemicalMachineComponent.Template template) {
        graphics.renderFakeItem(((ItemBlockChemicalTank)MekanismBlocks.ULTIMATE_CHEMICAL_TANK.asItem()).getDefaultInstance(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
        graphics.drawString(Minecraft.getInstance().font, "id: \"" + template.getId() + "\"", x + 25, y + 15, FastColor.ARGB32.color((int)255, (int)128, (int)0, (int)0), false);
        graphics.drawString(Minecraft.getInstance().font, "mode: " + String.valueOf(template.mode()), x + 25, y + 25, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)128), false);
    }

    public static class ChemicalComponentBuilderPopup
    extends ComponentBuilderPopup<ChemicalMachineComponent.Template> {
        private EditBox id;
        private CycleButton<ComponentIOMode> mode;
        private EditBox capacity;
        private EditBox maxInput;
        private EditBox minInput;
        private EditBox maxOutput;
        private EditBox minOutput;
        private Filter<Chemical> filter;
        private IOSideConfig.Template config;
        private Checkbox unique;
        private Checkbox radiations;

        public ChemicalComponentBuilderPopup(BaseScreen parent, @Nullable ChemicalMachineComponent.Template template, Consumer<ChemicalMachineComponent.Template> onFinish, Component title) {
            super(parent, (IMachineComponentTemplate)template, onFinish, title);
        }

        public ChemicalMachineComponent.Template makeTemplate() {
            return new ChemicalMachineComponent.Template(this.id.getValue(), this.parseLong(this.capacity.getValue()), (ComponentIOMode)this.mode.getValue(), this.filter, this.parseLong(this.maxInput.getValue()), this.parseLong(this.minInput.getValue()), this.parseLong(this.maxOutput.getValue()), this.parseLong(this.minOutput.getValue()), this.config, this.unique.selected(), this.radiations.selected());
        }

        public Component canCreate() {
            MachineEditScreen screen;
            if (this.id.getValue().isEmpty()) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.missing");
            }
            BaseScreen baseScreen = this.parent;
            if (baseScreen instanceof MachineEditScreen && (screen = (MachineEditScreen)baseScreen).getBuilder().getComponents().stream().anyMatch(template -> template.getType() == Registration.CHEMICAL_MACHINE_COMPONENT.get() && this.baseTemplate().map(base -> base != template).orElse(true) != false && template.getId().equals(this.id.getValue()))) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.duplicate", (Object[])new Object[]{this.id.getValue()});
            }
            return Component.empty();
        }

        protected void init() {
            super.init();
            this.id = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.id"), (AbstractWidget)new EditBox(Minecraft.getInstance().font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.id")));
            this.baseTemplate().ifPresentOrElse(template -> this.id.setValue(template.getId()), () -> this.id.setValue("input"));
            this.id.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.components.id.tooltip")));
            this.mode = (CycleButton)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.mode"), (AbstractWidget)CycleButton.builder(ComponentIOMode::toComponent).displayOnlyValue().withValues((Object[])ComponentIOMode.values()).withInitialValue((Object)ComponentIOMode.BOTH).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.mode")));
            this.baseTemplate().ifPresent(template -> this.mode.setValue((Object)template.mode()));
            this.capacity = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.capacity"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.capacity")));
            this.capacity.setFilter(arg_0 -> ((ChemicalComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.capacity.setValue("" + template.capacity()), () -> this.capacity.setValue("10000"));
            this.maxInput = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.maxInput"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.maxInput")));
            this.maxInput.setFilter(arg_0 -> ((ChemicalComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.maxInput.setValue("" + template.maxInput()), () -> this.maxInput.setValue("10000"));
            this.minInput = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.minInput"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.minInput")));
            this.minInput.setFilter(arg_0 -> ((ChemicalComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.minInput.setValue("" + template.minInput()), () -> this.minInput.setValue("0"));
            this.maxOutput = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.maxOutput"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.maxOutput")));
            this.maxOutput.setFilter(arg_0 -> ((ChemicalComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.maxOutput.setValue("" + template.maxOutput()), () -> this.maxOutput.setValue("10000"));
            this.minOutput = (EditBox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.minOutput"), (AbstractWidget)new EditBox(this.font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.minOutput")));
            this.minOutput.setFilter(arg_0 -> ((ChemicalComponentBuilderPopup)this).checkLong(arg_0));
            this.baseTemplate().ifPresentOrElse(template -> this.minOutput.setValue("" + template.minOutput()), () -> this.minOutput.setValue("0"));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.filter = template.filter();
            }, () -> {
                this.filter = Filter.empty();
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter"), (AbstractWidget)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter"), button -> this.parent.openPopup((PopupScreen)new FilterConfigPopup(this.parent, () -> this.filter, filter -> {
                this.filter = filter;
            }, (FilterConfigPopup.FilterBuilderHelper)new ChemicalFilterHelper()), "Chemical Filter")).size(180, 20).build());
            this.baseTemplate().ifPresentOrElse(template -> {
                this.config = template.config();
            }, () -> {
                this.config = IOSideConfig.Template.DEFAULT_ALL_INPUT;
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.config.component"), (AbstractWidget)ComponentConfigBuilderWidget.make((int)0, (int)0, (int)180, (int)20, (Component)Component.translatable((String)"custommachinery.gui.config.component"), (BaseScreen)this.parent, () -> this.config, template -> {
                this.config = template;
            }));
            this.unique = (Checkbox)this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.fluid.unique"), (AbstractWidget)Checkbox.builder((Component)Component.empty(), (Font)this.font).selected(false).build());
            if (this.baseTemplate().map(ChemicalMachineComponent.Template::unique).orElse(false).booleanValue() != this.unique.selected()) {
                this.unique.onPress();
            }
            this.radiations = (Checkbox)this.propertyList.add((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.chemical.radiations"), (AbstractWidget)Checkbox.builder((Component)Component.empty(), (Font)this.font).selected(false).build());
            this.radiations.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.chemical.radiations.tooltip")));
            if (this.baseTemplate().map(ChemicalMachineComponent.Template::radiations).orElse(false).booleanValue() != this.radiations.selected()) {
                this.radiations.onPress();
            }
        }
    }

    private static class ChemicalFilterHelper
    implements FilterConfigPopup.FilterBuilderHelper<Chemical> {
        private ChemicalFilterHelper() {
        }

        public void renderSingle(Chemical single, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.enableBlend();
            MekanismRenderer.color((GuiGraphics)graphics, (ChemicalStack)new ChemicalStack(Holder.direct((Object)single), 1L));
            GuiUtils.drawTiledSprite((GuiGraphics)graphics, (int)0, (int)0, (int)16, (int)16, (int)16, (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)single.getIcon()), (int)16, (int)16, (int)0, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_RIGHT, (boolean)false);
            MekanismRenderer.resetColor((GuiGraphics)graphics);
            RenderSystem.disableBlend();
        }

        public Component tooltip(Chemical single) {
            return single.getTextComponent();
        }

        public Registry<Chemical> registry() {
            return MekanismAPI.CHEMICAL_REGISTRY;
        }

        public Stream<ResourceLocation> getAll() {
            return this.registry().entrySet().stream().map(entry -> ((ResourceKey)entry.getKey()).location());
        }

        public Chemical defaultValue() {
            return ChemicalStack.EMPTY.getChemical();
        }
    }
}

