/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class StackIngredient
implements ICustomIngredient {
    public static final StackIngredient EMPTY = new StackIngredient((HolderSet<Item>)HolderSet.empty(), 0);
    public static final MapCodec<StackIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(StackIngredient::items), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    private final int count;
    private final HolderSet<Item> items;
    private final ItemStack[] stacks;

    public StackIngredient(HolderSet<Item> items, int count) {
        this.items = items;
        this.count = count;
        this.stacks = (ItemStack[])items.stream().map(i -> new ItemStack(i, count)).toArray(ItemStack[]::new);
    }

    public int getCount() {
        return this.count;
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)DEContent.STACK_INGREDIENT_TYPE.get();
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(this.stacks);
    }

    public boolean test(ItemStack stack) {
        return this.items.contains(stack.getItemHolder()) && stack.getCount() >= this.count;
    }

    public HolderSet<Item> items() {
        return this.items;
    }

    public static Ingredient of(int count, ItemStack stack) {
        return StackIngredient.of(count, new ItemLike[]{stack.getItem()});
    }

    public static Ingredient of(int count, ItemLike ... items) {
        return StackIngredient.of(count, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    @SafeVarargs
    public static Ingredient of(int count, Holder<Item> ... items) {
        return StackIngredient.of(count, (HolderSet<Item>)HolderSet.direct(items));
    }

    public static Ingredient of(int count, HolderSet<Item> items) {
        return new StackIngredient(items, count).toVanilla();
    }
}

