/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class EnergyLinkEntity
extends ModuleEntity<EnergyLinkData> {
    private Optional<GlobalPos> linkedPos = Optional.empty();
    private Optional<UUID> linkId = Optional.empty();
    private long linkCharge = 0L;
    private BooleanProperty enabled = new BooleanProperty("energy_link_mod.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
    private double flow = 0.0;
    public static final Codec<EnergyLinkEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(EnergyLinkEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)GlobalPos.CODEC.optionalFieldOf("linked_pos").forGetter(e -> e.linkedPos), (App)UUIDUtil.CODEC.optionalFieldOf("link_id").forGetter(e -> e.linkId), (App)Codec.LONG.fieldOf("link_charge").forGetter(e -> e.linkCharge), (App)BooleanProperty.CODEC.fieldOf("enabled").forGetter(e -> e.enabled)).apply((Applicative)builder, EnergyLinkEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnergyLinkEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), EnergyLinkEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), energyLinkEntity -> energyLinkEntity.linkedPos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), energyLinkEntity -> energyLinkEntity.linkId, (StreamCodec)ByteBufCodecs.VAR_LONG, energyLinkEntity -> energyLinkEntity.linkCharge, BooleanProperty.STREAM_CODEC, energyLinkEntity -> energyLinkEntity.enabled, EnergyLinkEntity::new);

    public EnergyLinkEntity(Module<EnergyLinkData> module) {
        super(module);
    }

    EnergyLinkEntity(Module<?> module, int gridX, int gridY, Optional<GlobalPos> linkedPos, Optional<UUID> linkId, long linkCharge, BooleanProperty enabled) {
        super(module, gridX, gridY);
        this.linkedPos = linkedPos;
        this.linkId = linkId;
        this.linkCharge = linkCharge;
        this.enabled = enabled;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new EnergyLinkEntity(this.module, this.getGridX(), this.getGridY(), this.linkedPos, this.linkId, this.linkCharge, this.enabled.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        properties.add(this.enabled);
    }

    @Override
    public Module<EnergyLinkData> getModule() {
        return super.getModule();
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        TileEnergyCore core;
        boolean crossDimension;
        IOPStorage storage;
        block16: {
            block15: {
                StackModuleContext context;
                GlobalPos linkedPos;
                block14: {
                    block13: {
                        if (this.linkId.isEmpty() || this.linkedPos.isEmpty()) {
                            return;
                        }
                        linkedPos = this.linkedPos.get();
                        storage = moduleContext.getOpStorage();
                        if (!(moduleContext instanceof StackModuleContext)) break block13;
                        context = (StackModuleContext)moduleContext;
                        if (storage != null) break block14;
                    }
                    return;
                }
                Level level = context.getEntity().level();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                crossDimension = false;
                if (!level.dimension().equals(linkedPos.dimension())) {
                    crossDimension = true;
                    level = serverLevel.getServer().getLevel(linkedPos.dimension());
                    if (level == null) {
                        return;
                    }
                }
                if (!level.isLoaded(linkedPos.pos())) {
                    return;
                }
                BlockEntity entity = level.getBlockEntity(linkedPos.pos());
                if (!(entity instanceof TileEnergyCore)) break block15;
                core = (TileEnergyCore)entity;
                if (this.linkId.get().equals(core.linkUUID.get())) break block16;
            }
            this.clear();
            return;
        }
        EnergyLinkData data = (EnergyLinkData)this.module.getData();
        if (!this.enabled.getValue() || crossDimension && !data.xDimensional()) {
            this.disconnect();
            return;
        }
        if (!this.updateConnection(data, storage, core)) {
            return;
        }
        long inserted = core.energy.extractOP(storage.modifyEnergyStored(core.energy.extractOP(data.transferLimit(), true)), false);
        this.flow = MathHelper.approachExp((double)this.flow, (double)inserted, (double)0.05);
        this.markDirty();
    }

    private boolean updateConnection(EnergyLinkData data, IOPStorage storage, TileEnergyCore core) {
        if (core.energy.getOPStored() < data.operationEnergy() * 20L) {
            this.disconnect();
            return false;
        }
        if (this.linkCharge < data.activationEnergy()) {
            long chargeRate = Math.max(1L, data.activationEnergy() / 600L);
            long remaining = data.activationEnergy() - this.linkCharge;
            this.linkCharge += storage.modifyEnergyStored(-Math.min(remaining, chargeRate));
            this.markDirty();
            return false;
        }
        long maintenanceCost = (long)((double)data.operationEnergy() * 0.1 + (double)data.operationEnergy() * 0.9 * (this.flow / (double)data.transferLimit()));
        long extracted = core.energy.extractOP(maintenanceCost, false);
        if (extracted < maintenanceCost) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private void disconnect() {
        this.linkCharge = 0L;
        this.flow = 0.0;
        this.markDirty();
    }

    private void clear() {
        this.linkId = Optional.empty();
        this.linkedPos = Optional.empty();
        this.markDirty();
    }

    @Override
    public void onInstalled(ModuleContext context) {
        super.onInstalled(context);
        this.linkCharge = 0L;
        this.markDirty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean stackRender, float partialTicks) {
        boolean crossDimension;
        super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, stackRender, partialTicks);
        EnergyLinkData data = (EnergyLinkData)this.module.getData();
        if (this.linkCharge >= data.activationEnergy()) {
            return;
        }
        double progress = (double)this.linkCharge / (double)data.activationEnergy();
        boolean bl = crossDimension = this.linkedPos.isPresent() && render.mc().level.dimension() != this.linkedPos.get().dimension();
        if (crossDimension && !data.xDimensional()) {
            render.rect((double)x, (double)y, (double)width, (double)height, 0x60FF0000);
            return;
        }
        String pText = (int)(progress * 100.0) + "%";
        MutableComponent progressText = Component.translatable((String)"module.draconicevolution.energy_link.charging").append(StringUtils.repeat((String)".", (int)((int)(System.currentTimeMillis() / 500L % 4L))));
        this.drawChargeProgress(render, x, y, width, height, progress, (Component)Component.literal((String)pText), (Component)progressText);
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        if (this.linkId.isPresent() && this.linkedPos.isPresent()) {
            stack.set(ItemData.LINK_MODULE_LINK_POS, (Object)this.linkedPos.get());
            stack.set(ItemData.LINK_MODULE_LINK_ID, (Object)this.linkId.get());
        }
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.linkedPos = Optional.ofNullable((GlobalPos)stack.get(ItemData.LINK_MODULE_LINK_POS));
        this.linkId = Optional.ofNullable((UUID)stack.get(ItemData.LINK_MODULE_LINK_ID));
    }

    @Override
    public void addToolTip(List<Component> list) {
        if (this.linkId.isPresent() && this.linkedPos.isPresent()) {
            GlobalPos gPos = this.linkedPos.get();
            list.add((Component)Component.translatable((String)"module.draconicevolution.energy_link.linked_core").withStyle(ChatFormatting.GRAY).append(": ").append((Component)Component.literal((String)("X:" + gPos.pos().getX() + ", Y:" + gPos.pos().getY() + ", Z:" + gPos.pos().getZ() + ", " + String.valueOf(gPos.dimension().location()))).withStyle(ChatFormatting.DARK_GREEN)));
        } else {
            list.add((Component)Component.translatable((String)"module.draconicevolution.energy_link.link_to_core").withStyle(ChatFormatting.GRAY));
        }
    }
}

