/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.FlowGateMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileFluxGate
extends TileFlowGate {
    private OPRegulator inputReg = new OPRegulator(this, true);
    private OPRegulator outputReg = new OPRegulator(this, false);
    private boolean capsLoaded = false;

    public TileFluxGate(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_FLUX_GATE.get(), pos, state);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(CapabilityOP.BLOCK, (BlockEntityType)DEContent.TILE_FLUX_GATE.get(), (tile, side) -> {
            if (!tile.capsLoaded) {
                tile.updateCapabilities();
                tile.capsLoaded = true;
            }
            return (IOPStorage)tile.getCapManager().getCapability(CapabilityOP.BLOCK, side);
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)DEContent.TILE_FLUX_GATE.get(), (tile, side) -> {
            if (!tile.capsLoaded) {
                tile.updateCapabilities();
                tile.capsLoaded = true;
            }
            return (IEnergyStorage)tile.getCapManager().getCapability(CapabilityOP.BLOCK, side);
        });
    }

    @Override
    public String getUnits() {
        return "RF/t";
    }

    private void updateCapabilities() {
        this.capManager.remove(CapabilityOP.BLOCK, new Direction[0]);
        this.capManager.set(CapabilityOP.BLOCK, (Object)this.inputReg, new Direction[]{this.getDirection().getOpposite()});
        this.capManager.set(CapabilityOP.BLOCK, (Object)this.outputReg, new Direction[]{this.getDirection()});
    }

    @Override
    public void setBlockState(BlockState p_155251_) {
        super.setBlockState(p_155251_);
        this.updateCapabilities();
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new FlowGateMenu(id, player.getInventory(), this);
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, this.worldPosition);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        if (this.flowOverridden.get()) {
            return;
        }
        try {
            String value = data.readString();
            long l = Long.parseLong(value);
            if (l < 0L) {
                l = 0L;
            }
            if (id == 0) {
                this.minFlow.set(l);
            } else if (id == 1) {
                this.maxFlow.set(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class OPRegulator
    implements IOPStorage {
        private TileFluxGate tile;
        private boolean isInput;

        public OPRegulator(TileFluxGate tile, boolean isInput) {
            this.tile = tile;
            this.isInput = isInput;
        }

        public long receiveOP(long maxReceive, boolean simulate) {
            if (this.isInput) {
                BlockEntity target = this.tile.getTarget();
                if (target == null) {
                    return 0L;
                }
                Direction tInputSide = this.tile.getDirection().getOpposite();
                long sim = EnergyUtils.insertEnergy((BlockEntity)target, (long)maxReceive, (Direction)tInputSide, (boolean)true);
                long transfer = EnergyUtils.insertEnergy((BlockEntity)target, (long)Math.min(Math.max(0L, this.tile.getFlow() - this.tile.transferThisTick), sim), (Direction)tInputSide, (boolean)simulate);
                if (!simulate) {
                    this.tile.transferThisTick += transfer;
                }
                return transfer;
            }
            return 0L;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            if (!this.isInput) {
                BlockEntity source = this.tile.getSource();
                if (source == null) {
                    return 0L;
                }
                Direction tExtractSide = this.tile.getDirection();
                long sim = EnergyUtils.extractEnergy((BlockEntity)source, (long)maxExtract, (Direction)tExtractSide, (boolean)true);
                long transfer = EnergyUtils.extractEnergy((BlockEntity)source, (long)Math.min(Math.max(0L, this.tile.getFlow() - this.tile.transferThisTick), sim), (Direction)tExtractSide, (boolean)simulate);
                if (!simulate) {
                    this.tile.transferThisTick += transfer;
                }
                return transfer;
            }
            return 0L;
        }

        public long getOPStored() {
            if (this.isInput) {
                return 0L;
            }
            BlockEntity target = this.tile.getTarget();
            if (target == null) {
                return 0L;
            }
            return EnergyUtils.getEnergyStored((BlockEntity)target, (Direction)this.tile.getDirection().getOpposite());
        }

        public long getMaxOPStored() {
            if (this.isInput) {
                return 0L;
            }
            BlockEntity target = this.tile.getTarget();
            if (target == null) {
                return 0L;
            }
            return EnergyUtils.getMaxEnergyStored((BlockEntity)target, (Direction)this.tile.getDirection().getOpposite());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.receiveOP(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getOPStored());
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getMaxOPStored());
        }

        public long modifyEnergyStored(long amount) {
            return 0L;
        }

        public boolean canExtract() {
            return !this.isInput;
        }

        public boolean canReceive() {
            return this.isInput;
        }
    }
}

