/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.tileentity.StabilizedSpawnerLogic;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RenderTileStabilizedSpawner
implements BlockEntityRenderer<TileStabilizedSpawner> {
    private static final ItemStack[] CORE_RENDER_ITEMS = new ItemStack[]{new ItemStack((ItemLike)DEContent.CORE_DRACONIUM.get()), new ItemStack((ItemLike)DEContent.CORE_WYVERN.get()), new ItemStack((ItemLike)DEContent.CORE_AWAKENED.get()), new ItemStack((ItemLike)DEContent.CORE_CHAOTIC.get())};

    public RenderTileStabilizedSpawner(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileStabilizedSpawner tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        StabilizedSpawnerLogic spawnerLogic = tile.spawnerLogic;
        mStack.pushPose();
        mStack.translate(0.5, 0.0, 0.5);
        Entity entity = spawnerLogic.getOrCreateDisplayEntity(tile.getLevel(), tile.getBlockPos());
        if (entity != null) {
            float f = 0.53125f;
            float f1 = Math.max(entity.getBbWidth(), entity.getBbHeight());
            if ((double)f1 > 1.0) {
                f /= f1;
            }
            mStack.translate(0.0, (double)0.4f, 0.0);
            mStack.mulPose(Axis.YP.rotationDegrees((float)Mth.lerp((double)partialTicks, (double)spawnerLogic.getoSpin(), (double)spawnerLogic.getSpin()) * 10.0f));
            mStack.translate(0.0, (double)-0.2f, 0.0);
            mStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
            mStack.scale(f, f, f);
            Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, mStack, getter, packedLight);
        }
        mStack.popPose();
        mStack.translate(0.5, 0.96875, 0.5);
        mStack.scale(0.75f, 0.75f, 0.75f);
        mStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        ItemStack stack = CORE_RENDER_ITEMS[((TileStabilizedSpawner.SpawnerTier)tile.spawnerTier.get()).ordinal()];
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, mStack, getter, tile.getLevel(), tile.posSeed());
    }
}

