/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import codechicken.lib.config.ConfigCategory;
import com.brandon3055.brandonscore.api.TechLevel;

public class EquipCfg {
    private static final double DRACONIUM_HARVEST_SPEED = 10.0;
    private static final double WYVERN_HARVEST_SPEED = 15.0;
    private static final double DRACONIC_HARVEST_SPEED = 25.0;
    private static final double CHAOTIC_HARVEST_SPEED = 50.0;
    private static final double DRACONIUM_DAMAGE = 1.125;
    private static final double WYVERN_DAMAGE = 1.25;
    private static final double DRACONIC_DAMAGE = 1.75;
    private static final double CHAOTIC_DAMAGE = 2.5;
    private static final double DRACONIUM_SWING_SPEED = 1.125;
    private static final double WYVERN_SWING_SPEED = 1.25;
    private static final double DRACONIC_SWING_SPEED = 1.5;
    private static final double CHAOTIC_SWING_SPEED = 2.0;
    private static final int DRACONIUM_ENCHANT = 12;
    private static final int WYVERN_ENCHANT = 15;
    private static final int DRACONIC_ENCHANT = 25;
    private static final int CHAOTIC_ENCHANT = 35;
    private static final double STAFF_DMG_MULT = 9.0;
    private static final double SWORD_DMG_MULT = 7.0;
    private static final double AXE_DMG_MULT = 9.0;
    private static final double PICKAXE_DMG_MULT = 5.0;
    private static final double SHOVEL_DMG_MULT = 5.5;
    private static final double HOE_DMG_MULT = 1.0;
    private static final double STAFF_SWING_SPEED_MULT = 0.5;
    private static final double SWORD_SWING_SPEED_MULT = 1.6;
    private static final double AXE_SWING_SPEED_MULT = 1.0;
    private static final double PICKAXE_SWING_SPEED_MULT = 1.2;
    private static final double SHOVEL_SWING_SPEED_MULT = 1.0;
    private static final double HOE_SWING_SPEED_MULT = 4.0;
    private static final double STAFF_EFF_MULT = 3.0;
    private static final long DRACONIUM_BASE_ENERGY = 0L;
    private static final long WYVERN_BASE_ENERGY = 0L;
    private static final long DRACONIC_BASE_ENERGY = 0L;
    private static final long CHAOTIC_BASE_ENERGY = 0L;
    private static final double STAFF_ENERGY_MULT = 3.0;
    private static final double TOOL_ENERGY_MULT = 1.0;
    private static final double CAPACITOR_ENERGY_MULT = 8.0;
    private static final double CHESTPIECE_ENERGY_MULT = 2.0;
    private static final int ENERGY_HARVEST = 256;
    private static final int ENERGY_ATTACK = 1024;
    private static final int ENERGY_SHIELD_CHG = 8192;
    private static final double SHIELD_PASSIVE_MODIFIER = 5.0E-4;
    private static final int ELYTRA_FLIGHT_ENERGY = 1024;
    private static final int CREATIVE_FLIGHT_ENERGY = 4096;
    private static final int ELYTRA_WYVERN_ENERGY = 1024;
    private static final int ELYTRA_DRACONIC_ENERGY = 2048;
    private static final int ELYTRA_CHAOTIC_ENERGY = 8192;
    private static final int BOW_BASE_ENERGY = 1024;
    private static final int ENDER_MODULE_PER_ITEM_ENERGY = 32;
    private static final int NIGHT_VISION_ENERGY = 20;
    public static double draconiumHarvestSpeed;
    public static double wyvernHarvestSpeed;
    public static double draconicHarvestSpeed;
    public static double chaoticHarvestSpeed;
    public static double draconiumDamage;
    public static double wyvernDamage;
    public static double draconicDamage;
    public static double chaoticDamage;
    public static double draconiumSwingSpeed;
    public static double wyvernSwingSpeed;
    public static double draconicSwingSpeed;
    public static double chaoticSwingSpeed;
    public static int draconiumEnchantability;
    public static int wyvernEnchantability;
    public static int draconicEnchantability;
    public static int chaoticEnchantability;
    public static double staffDamageMultiplier;
    public static double swordDamageMultiplier;
    public static double axeDamageMultiplier;
    public static double pickaxeDamageMultiplier;
    public static double shovelDamageMultiplier;
    public static double hoeDamageMultiplier;
    public static double staffSwingSpeedMultiplier;
    public static double swordSwingSpeedMultiplier;
    public static double axeSwingSpeedMultiplier;
    public static double pickaxeSwingSpeedMultiplier;
    public static double shovelSwingSpeedMultiplier;
    public static double hoeSwingSpeedMultiplier;
    public static double staffEffMultiplier;
    public static long draconiumBaseEnergy;
    public static long wyvernBaseEnergy;
    public static long draconicBaseEnergy;
    public static long chaoticBaseEnergy;
    public static double staffEnergyMult;
    public static double toolEnergyMult;
    public static double capacitorEnergyMult;
    public static double chestpieceEnergyMult;
    public static int energyHarvest;
    public static int energyAttack;
    public static int energyShieldChg;
    public static double shieldPassiveModifier;
    public static int elytraFlightEnergy;
    public static int creativeFlightEnergy;
    public static int elytraWyvernEnergy;
    public static int elytraDraconicEnergy;
    public static int elytraChaoticEnergy;
    public static int bowBaseEnergy;
    public static int enderModulePerItemEnergy;
    public static int nightVisionEnergy;

    public static void loadConfig(ConfigCategory configTag) {
        ConfigCategory equipTag = configTag.getCategory("Equipment");
        equipTag.setComment(new String[]{"These settings allow you to override the base stats for DE's equipment.", "Please note the generated default values \"-99\" is actually a marker that tells DE to use the actual internal default value.", "This value is listed in each properties description but may not be valid if this config was generated by a previous version of DE."});
        equipTag.getValue("draconiumHarvestSpeed").setComment("Internal Default Value: 10.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            draconiumHarvestSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 10.0;
        });
        equipTag.getValue("wyvernHarvestSpeed").setComment("Internal Default Value: 15.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            wyvernHarvestSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 15.0;
        });
        equipTag.getValue("draconicHarvestSpeed").setComment("Internal Default Value: 25.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            draconicHarvestSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 25.0;
        });
        equipTag.getValue("chaoticHarvestSpeed").setComment("Internal Default Value: 50.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            chaoticHarvestSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 50.0;
        });
        equipTag.getValue("draconiumDamage").setComment("Base Attack Damage\nInternal Default Value: 1.125").setDefaultDouble(-99.0).onSync((tag, type) -> {
            draconiumDamage = tag.getDouble() != -99.0 ? tag.getDouble() : 1.125;
        });
        equipTag.getValue("wyvernDamage").setComment("Base Attack Damage\nInternal Default Value: 1.25").setDefaultDouble(-99.0).onSync((tag, type) -> {
            wyvernDamage = tag.getDouble() != -99.0 ? tag.getDouble() : 1.25;
        });
        equipTag.getValue("draconicDamage").setComment("Base Attack Damage\nInternal Default Value: 1.75").setDefaultDouble(-99.0).onSync((tag, type) -> {
            draconicDamage = tag.getDouble() != -99.0 ? tag.getDouble() : 1.75;
        });
        equipTag.getValue("chaoticDamage").setComment("Base Attack Damage\nInternal Default Value: 2.5").setDefaultDouble(-99.0).onSync((tag, type) -> {
            chaoticDamage = tag.getDouble() != -99.0 ? tag.getDouble() : 2.5;
        });
        equipTag.getValue("draconiumSwingSpeed").setComment("Base Attack Speed (How many times you can attack at full power per second)\nInternal Default Value: 1.125").setDefaultDouble(-99.0).onSync((tag, type) -> {
            draconiumSwingSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 1.125;
        });
        equipTag.getValue("wyvernSwingSpeed").setComment("Base Attack Speed (How many times you can attack at full power per second)\nInternal Default Value: 1.25").setDefaultDouble(-99.0).onSync((tag, type) -> {
            wyvernSwingSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 1.25;
        });
        equipTag.getValue("draconicSwingSpeed").setComment("Base Attack Speed (How many times you can attack at full power per second)\nInternal Default Value: 1.5").setDefaultDouble(-99.0).onSync((tag, type) -> {
            draconicSwingSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 1.5;
        });
        equipTag.getValue("chaoticSwingSpeed").setComment("Base Attack Speed (How many times you can attack at full power per second)\nInternal Default Value: 2.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            chaoticSwingSpeed = tag.getDouble() != -99.0 ? tag.getDouble() : 2.0;
        });
        equipTag.getValue("draconiumEnchantability").setComment("Internal Default Value: 12").setDefaultInt(-99).onSync((tag, type) -> {
            draconiumEnchantability = tag.getInt() != -99 ? tag.getInt() : 12;
        });
        equipTag.getValue("wyvernEnchantability").setComment("Internal Default Value: 15").setDefaultInt(-99).onSync((tag, type) -> {
            wyvernEnchantability = tag.getInt() != -99 ? tag.getInt() : 15;
        });
        equipTag.getValue("draconicEnchantability").setComment("Internal Default Value: 25").setDefaultInt(-99).onSync((tag, type) -> {
            draconicEnchantability = tag.getInt() != -99 ? tag.getInt() : 25;
        });
        equipTag.getValue("chaoticEnchantability").setComment("Internal Default Value: 35").setDefaultInt(-99).onSync((tag, type) -> {
            chaoticEnchantability = tag.getInt() != -99 ? tag.getInt() : 35;
        });
        equipTag.getValue("staffDamageMultiplier").setComment("This is a multiplier that is applied to the base attack damage\nInternal Default Value: 9.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            staffDamageMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 9.0;
        });
        equipTag.getValue("swordDamageMultiplier").setComment("This is a multiplier that is applied to the base attack damage\nInternal Default Value: 7.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            swordDamageMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 7.0;
        });
        equipTag.getValue("axeDamageMultiplier").setComment("This is a multiplier that is applied to the base attack damage\nInternal Default Value: 9.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            axeDamageMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 9.0;
        });
        equipTag.getValue("pickaxeDamageMultiplier").setComment("This is a multiplier that is applied to the base attack damage\nInternal Default Value: 5.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            pickaxeDamageMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 5.0;
        });
        equipTag.getValue("shovelDamageMultiplier").setComment("This is a multiplier that is applied to the base attack damage\nInternal Default Value: 5.5").setDefaultDouble(-99.0).onSync((tag, type) -> {
            shovelDamageMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 5.5;
        });
        equipTag.getValue("hoeDamageMultiplier").setComment("This is a multiplier that is applied to the base attack damage\nInternal Default Value: 1.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            hoeDamageMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 1.0;
        });
        equipTag.getValue("staffSwingSpeedMultiplier").setComment("This is a multiplier that is applied to the base attack speed\nInternal Default Value: 0.5").setDefaultDouble(-99.0).onSync((tag, type) -> {
            staffSwingSpeedMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 0.5;
        });
        equipTag.getValue("swordSwingSpeedMultiplier").setComment("This is a multiplier that is applied to the base attack speed\nInternal Default Value: 1.6").setDefaultDouble(-99.0).onSync((tag, type) -> {
            swordSwingSpeedMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 1.6;
        });
        equipTag.getValue("axeSwingSpeedMultiplier").setComment("This is a multiplier that is applied to the base attack speed\nInternal Default Value: 1.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            axeSwingSpeedMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 1.0;
        });
        equipTag.getValue("pickaxeSwingSpeedMultiplier").setComment("This is a multiplier that is applied to the base attack speed\nInternal Default Value: 1.2").setDefaultDouble(-99.0).onSync((tag, type) -> {
            pickaxeSwingSpeedMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 1.2;
        });
        equipTag.getValue("shovelSwingSpeedMultiplier").setComment("This is a multiplier that is applied to the base attack speed\nInternal Default Value: 1.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            shovelSwingSpeedMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 1.0;
        });
        equipTag.getValue("hoeSwingSpeedMultiplier").setComment("This is a multiplier that is applied to the base attack speed\nInternal Default Value: 4.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            hoeSwingSpeedMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 4.0;
        });
        equipTag.getValue("staffEfficiencyMultiplier").setComment("This is an efficiency multiplier specifically for the staff of power.\nThe staff gets its own multiplier because its a \"special tool\"\nInternal Default Value: 3.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            staffEffMultiplier = tag.getDouble() != -99.0 ? tag.getDouble() : 3.0;
        });
        equipTag.getValue("draconiumBaseEnergy").setComment("This is the base energy value for each tier before the type multiplier is applied.\nInternal Default Value: 0").setDefaultLong(-99L).onSync((tag, type) -> {
            draconiumBaseEnergy = tag.getLong() != -99L ? tag.getLong() : 0L;
        });
        equipTag.getValue("wyvernBaseEnergy").setComment("This is the base energy value for each tier before the type multiplier is applied.\nInternal Default Value: 0").setDefaultLong(-99L).onSync((tag, type) -> {
            wyvernBaseEnergy = tag.getLong() != -99L ? tag.getLong() : 0L;
        });
        equipTag.getValue("draconicBaseEnergy").setComment("This is the base energy value for each tier before the type multiplier is applied.\nInternal Default Value: 0").setDefaultLong(-99L).onSync((tag, type) -> {
            draconicBaseEnergy = tag.getLong() != -99L ? tag.getLong() : 0L;
        });
        equipTag.getValue("chaoticBaseEnergy").setComment("This is the base energy value for each tier before the type multiplier is applied.\nInternal Default Value: 0").setDefaultLong(-99L).onSync((tag, type) -> {
            chaoticBaseEnergy = tag.getLong() != -99L ? tag.getLong() : 0L;
        });
        equipTag.getValue("staffEnergyMult").setComment("This is a multiplier that is applied to the base energy value.\nInternal Default Value: 3.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            staffEnergyMult = tag.getDouble() != -99.0 ? tag.getDouble() : 3.0;
        });
        equipTag.getValue("toolEnergyMult").setComment("This is a multiplier that is applied to the base energy value.\nInternal Default Value: 1.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            toolEnergyMult = tag.getDouble() != -99.0 ? tag.getDouble() : 1.0;
        });
        equipTag.getValue("capacitorEnergyMult").setComment("This is a multiplier that is applied to the base energy value.\nInternal Default Value: 8.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            capacitorEnergyMult = tag.getDouble() != -99.0 ? tag.getDouble() : 8.0;
        });
        equipTag.getValue("chestpieceEnergyMult").setComment("This is a multiplier that is applied to the base energy value.\nInternal Default Value: 2.0").setDefaultDouble(-99.0).onSync((tag, type) -> {
            chestpieceEnergyMult = tag.getDouble() != -99.0 ? tag.getDouble() : 2.0;
        });
        equipTag.getValue("energyHarvest").setComment("This is the per block energy requirement of all mining tools.\nInternal Default Value: 256").setDefaultInt(-99).onSync((tag, type) -> {
            energyHarvest = tag.getInt() != -99 ? tag.getInt() : 256;
        });
        equipTag.getValue("energyAttack").setComment("This is the energy requirement for weapons. This is multiplied by the weapons attack damage.\nInternal Default Value: 1024").setDefaultInt(-99).onSync((tag, type) -> {
            energyAttack = tag.getInt() != -99 ? tag.getInt() : 1024;
        });
        equipTag.getValue("energyShieldChg").setComment("Shield recharge base energy per shield point.\nInternal Default Value: 8192").setDefaultInt(-99).onSync((tag, type) -> {
            energyShieldChg = tag.getInt() != -99 ? tag.getInt() : 8192;
        });
        equipTag.getValue("shieldPassiveModifier").setComment("This controls the shield's passive power usage. The formula is: passiveDraw = (shieldPoints^2 * shieldPassiveModifier) OP/t\nInternal Default Value: 5.0E-4").setDefaultDouble(-99.0).onSync((tag, type) -> {
            shieldPassiveModifier = tag.getDouble() != -99.0 ? tag.getDouble() : 5.0E-4;
        });
        equipTag.getValue("elytraFlightEnergy").setComment("Elytra flight energy use per tick.\nInternal Default Value: 1024").setDefaultInt(-99).onSync((tag, type) -> {
            elytraFlightEnergy = tag.getInt() != -99 ? tag.getInt() : 1024;
        });
        equipTag.getValue("creativeFlightEnergy").setComment("Creative flight energy use per tick.\nInternal Default Value: 4096").setDefaultInt(-99).onSync((tag, type) -> {
            creativeFlightEnergy = tag.getInt() != -99 ? tag.getInt() : 4096;
        });
        equipTag.getValue("elytraWyvernEnergy").setComment("Elytra boost energy per tick, Internal Default Value: 1024").setDefaultInt(-99).onSync((tag, type) -> {
            elytraWyvernEnergy = tag.getInt() != -99 ? tag.getInt() : 1024;
        });
        equipTag.getValue("elytraDraconicEnergy").setComment("Elytra boost energy per tick, Internal Default Value: 2048").setDefaultInt(-99).onSync((tag, type) -> {
            elytraDraconicEnergy = tag.getInt() != -99 ? tag.getInt() : 2048;
        });
        equipTag.getValue("elytraChaoticEnergy").setComment("Elytra boost energy per tick, Internal Default Value: 8192").setDefaultInt(-99).onSync((tag, type) -> {
            elytraChaoticEnergy = tag.getInt() != -99 ? tag.getInt() : 8192;
        });
        equipTag.getValue("bowBaseEnergy").setComment("Bow base energy per calculated damage point, per shot, Internal Default Value: 1024").setDefaultInt(-99).onSync((tag, type) -> {
            bowBaseEnergy = tag.getInt() != -99 ? tag.getInt() : 1024;
        });
        equipTag.getValue("enderModulePerItemEnergy").setComment("Energy required for the ender storage module to transfer one (single) item into storage, Internal Default Value: 32").setDefaultInt(-99).onSync((tag, type) -> {
            enderModulePerItemEnergy = tag.getInt() != -99 ? tag.getInt() : 32;
        });
        equipTag.getValue("nightVisionEnergy").setComment("Night vision module energy consumption while operation. (OP per tick), Internal Default Value: 20").setDefaultInt(-99).onSync((tag, type) -> {
            nightVisionEnergy = tag.getInt() != -99 ? tag.getInt() : 20;
        });
        equipTag.syncTagToClient();
    }

    public static float getStaffEffMult() {
        return (float)staffEffMultiplier;
    }

    public static long getBaseEnergy(TechLevel techLevel) {
        switch (techLevel) {
            case DRACONIUM: {
                return draconiumBaseEnergy;
            }
            case WYVERN: {
                return wyvernBaseEnergy;
            }
            case DRACONIC: {
                return draconicBaseEnergy;
            }
            case CHAOTIC: {
                return chaoticBaseEnergy;
            }
        }
        return 0L;
    }

    public static long getBaseToolEnergy(TechLevel techLevel) {
        return (long)((double)EquipCfg.getBaseEnergy(techLevel) * toolEnergyMult);
    }

    public static long getBaseToolTransfer(TechLevel techLevel) {
        return EquipCfg.getBaseToolEnergy(techLevel) / 64L;
    }

    public static long getBaseCapEnergy(TechLevel techLevel) {
        return (long)((double)EquipCfg.getBaseEnergy(techLevel) * capacitorEnergyMult);
    }

    public static long getBaseCapTransfer(TechLevel techLevel) {
        return EquipCfg.getBaseCapEnergy(techLevel) / 64L;
    }

    public static long getBaseStaffEnergy(TechLevel techLevel) {
        return (long)((double)EquipCfg.getBaseEnergy(techLevel) * staffEnergyMult);
    }

    public static long getBaseStaffTransfer(TechLevel techLevel) {
        return EquipCfg.getBaseStaffEnergy(techLevel) / 64L;
    }

    public static long getBaseChestpieceEnergy(TechLevel techLevel) {
        return (long)((double)EquipCfg.getBaseEnergy(techLevel) * chestpieceEnergyMult);
    }

    public static long getBaseChestpieceTransfer(TechLevel techLevel) {
        return EquipCfg.getBaseChestpieceEnergy(techLevel) / 64L;
    }

    public static int getElytraEnergy(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return elytraWyvernEnergy;
            }
            case DRACONIC: {
                return elytraDraconicEnergy;
            }
            case CHAOTIC: {
                return elytraChaoticEnergy;
            }
        }
        return 0;
    }
}

