/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class ShieldedServerBossInfo
extends ServerBossEvent {
    private float shieldPower = 0.0f;
    private int crystals = 0;
    private boolean immune = false;

    public ShieldedServerBossInfo(Component name, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        super(name, color, overlay);
    }

    public void setShieldPower(float shieldPower) {
        if (this.shieldPower != shieldPower) {
            this.shieldPower = shieldPower;
            if (this.isVisible()) {
                for (ServerPlayer player : this.players) {
                    DraconicNetwork.sendBossShieldPacket(player, this.getId(), 2, e -> e.writeFloat(this.shieldPower));
                }
            }
        }
    }

    public void setCrystals(int crystals) {
        if (this.crystals != crystals) {
            this.crystals = crystals;
            if (this.isVisible()) {
                for (ServerPlayer player : this.players) {
                    DraconicNetwork.sendBossShieldPacket(player, this.getId(), 3, e -> e.writeByte(this.crystals));
                }
            }
        }
    }

    public void setImmune(boolean immune) {
        if (this.immune != immune) {
            this.immune = immune;
            if (this.isVisible()) {
                for (ServerPlayer player : this.players) {
                    DraconicNetwork.sendBossShieldPacket(player, this.getId(), 4, e -> e.writeBoolean(this.immune));
                }
            }
        }
    }

    public void setVisible(boolean visible) {
        boolean prev = this.isVisible();
        super.setVisible(visible);
        if (prev != visible) {
            for (ServerPlayer player : this.players) {
                if (visible) {
                    DraconicNetwork.sendBossShieldPacket(player, this.getId(), 0, e -> e.writeFloat(this.shieldPower).writeByte(this.crystals).writeBoolean(this.immune));
                    continue;
                }
                DraconicNetwork.sendBossShieldPacket(player, this.getId(), 1, null);
            }
        }
    }

    public void addPlayer(ServerPlayer player) {
        if (this.players.add(player) && this.isVisible()) {
            player.connection.send((Packet)ClientboundBossEventPacket.createAddPacket((BossEvent)this));
            DraconicNetwork.sendBossShieldPacket(player, this.getId(), 0, e -> e.writeFloat(this.shieldPower).writeByte(this.crystals).writeBoolean(this.immune));
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (this.players.remove(player) && this.isVisible()) {
            player.connection.send((Packet)ClientboundBossEventPacket.createRemovePacket((UUID)this.getId()));
            DraconicNetwork.sendBossShieldPacket(player, this.getId(), 1, null);
        }
    }
}

