/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.util.InteractionUtil;
import com.glodblock.github.extendedae.common.EAESingletons;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemWirelessConnectTool
extends Item {
    public ItemWirelessConnectTool() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext ctx, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        Pair locator = (Pair)stack.get(EAESingletons.WIRELESS_LOCATOR);
        if (locator != null) {
            BlockPos pos;
            Long freq = (Long)locator.left();
            GlobalPos globalPos = (GlobalPos)locator.right();
            BlockPos blockPos = pos = globalPos != null ? globalPos.pos() : BlockPos.ZERO;
            if (freq != 0L) {
                lines.add((Component)Component.translatable((String)"wireless.tooltip", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GRAY));
                lines.add((Component)Component.translatable((String)"wireless.use.tooltip.02").withStyle(ChatFormatting.GRAY));
            } else {
                lines.add((Component)Component.translatable((String)"wireless.use.tooltip.01").withStyle(ChatFormatting.GRAY));
            }
        } else {
            lines.add((Component)Component.translatable((String)"wireless.use.tooltip.01").withStyle(ChatFormatting.GRAY));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (InteractionUtil.isInAlternateUseMode((Player)player) && stack.getItem() == EAESingletons.WIRELESS_TOOL) {
            stack.remove(EAESingletons.WIRELESS_LOCATOR);
            player.displayClientMessage((Component)Component.translatable((String)"chat.wireless_connect.clear"), true);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

