/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemFrameBlockRenderer
implements BlockEntityRenderer<ItemFrameBlockEntity> {
    public static final Map<ModelResourceLocation, ResourceLocation> ITEM_FRAME_BLOCK_MODELS = ImmutableMap.builder().put((Object)ModelResourceLocation.vanilla((String)"item_frame", (String)"map=false"), (Object)FastItemFrames.id("block/item_frame")).put((Object)ModelResourceLocation.vanilla((String)"glow_item_frame", (String)"map=false"), (Object)FastItemFrames.id("block/glow_item_frame")).put((Object)ModelResourceLocation.vanilla((String)"item_frame", (String)"map=true"), (Object)FastItemFrames.id("block/item_frame_map")).put((Object)ModelResourceLocation.vanilla((String)"glow_item_frame", (String)"map=true"), (Object)FastItemFrames.id("block/glow_item_frame_map")).build();
    private final EntityRenderDispatcher entityRenderer;

    public ItemFrameBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(ItemFrameBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemFrame itemFrame;
        if (!blockEntity.getItem().isEmpty() && (itemFrame = blockEntity.getEntityRepresentation()) != null) {
            EntityRenderer entityRenderer = this.entityRenderer.getRenderer((Entity)itemFrame);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.25f, 0.5f);
            Direction direction = itemFrame.getDirection();
            poseStack.translate((float)direction.getStepX() * -0.1675f, (float)direction.getStepY() * -0.46875f, (float)direction.getStepZ() * -0.1675f);
            if (!blockEntity.isInvisible()) {
                poseStack.translate((float)direction.getStepX() * 0.0625f, (float)direction.getStepY() * 0.0625f, (float)direction.getStepZ() * 0.0625f);
            }
            if (this.shouldShowName(blockEntity, itemFrame)) {
                entityRenderer.renderNameTag((Entity)itemFrame, itemFrame.getDisplayName(), poseStack, buffer, packedLight, partialTick);
            }
            boolean invisible = itemFrame.isInvisible();
            itemFrame.setInvisible(true);
            entityRenderer.render((Entity)itemFrame, 0.0f, partialTick, poseStack, buffer, packedLight);
            itemFrame.setInvisible(invisible);
            poseStack.popPose();
        }
    }

    public boolean shouldRender(ItemFrameBlockEntity blockEntity, Vec3 cameraPos) {
        ItemFrame itemFrame = blockEntity.getEntityRepresentation();
        if (itemFrame != null) {
            return itemFrame.shouldRender(cameraPos.x(), cameraPos.y(), cameraPos.z());
        }
        return super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    protected boolean shouldShowName(ItemFrameBlockEntity blockEntity, ItemFrame entity) {
        if (Minecraft.renderNames() && !entity.getItem().isEmpty() && entity.getItem().has(DataComponents.CUSTOM_NAME)) {
            Minecraft minecraft = Minecraft.getInstance();
            HitResult hitResult = minecraft.hitResult;
            if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK && blockEntity.getBlockPos().equals((Object)((BlockHitResult)hitResult).getBlockPos())) {
                double distanceToEntity = minecraft.gameRenderer.getMainCamera().getPosition().distanceToSqr(entity.position());
                double permittedDistance = entity.isDiscrete() ? 32.0 : 64.0;
                return distanceToEntity < permittedDistance * permittedDistance;
            }
        }
        return false;
    }
}

