/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.datagen.loot.objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;

public final class SplitCamoLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SplitCamoLootFunction> MAP_CODEC = RecordCodecBuilder.mapCodec(inst -> SplitCamoLootFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("camo_index").forGetter(func -> func.camoIndex)).apply((Applicative)inst, SplitCamoLootFunction::new));
    private static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<SplitCamoLootFunction>> TYPE = DeferredHolder.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (ResourceLocation)Utils.rl("split_camo"));
    private final int camoIndex;

    private SplitCamoLootFunction(List<LootItemCondition> conditions, int camoIndex) {
        super(conditions);
        this.camoIndex = camoIndex;
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        CamoContainer<?, ?> camo;
        CamoList camoList = (CamoList)stack.remove(Utils.DC_TYPE_CAMO_LIST);
        if (camoList != null && !camoList.isEmpty() && (camo = camoList.getCamo(this.camoIndex)) != EmptyCamoContainer.EMPTY) {
            stack.set(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.of(camo));
        }
        return stack;
    }

    public LootItemFunctionType<SplitCamoLootFunction> getType() {
        return (LootItemFunctionType)TYPE.value();
    }

    public static Builder split(int camoIndex) {
        return new Builder(camoIndex);
    }

    public static final class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final int camoIndex;

        private Builder(int camoIndex) {
            this.camoIndex = camoIndex;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new SplitCamoLootFunction(this.getConditions(), this.camoIndex);
        }
    }
}

