/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.joml.Vector4f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallGeometry
extends Geometry {
    private static final Vector4f[] rects = new Vector4f[]{new Vector4f(0.3125f, 0.0f, 0.6875f, 0.3125f), new Vector4f(0.3125f, 0.6875f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.3125f, 0.6875f), new Vector4f(0.6875f, 0.3125f, 1.0f, 0.6875f), new Vector4f(0.3125f, 0.0f, 0.6875f, 0.25f), new Vector4f(0.3125f, 0.75f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.25f, 0.6875f), new Vector4f(0.75f, 0.3125f, 1.0f, 0.6875f)};
    private static final float LOW_HEIGHT = 0.875f;
    private static final float SMALL_MIN = 0.3125f;
    private static final float SMALL_MAX = 0.6875f;
    private static final float LARGE_MIN = 0.25f;
    private static final float LARGE_MAX = 0.75f;
    private final boolean center;
    private final WallSide north;
    private final WallSide east;
    private final WallSide south;
    private final WallSide west;

    public FramedWallGeometry(GeometryFactory.Context ctx) {
        this.center = (Boolean)ctx.state().getValue((Property)BlockStateProperties.UP);
        this.north = (WallSide)ctx.state().getValue((Property)BlockStateProperties.NORTH_WALL);
        this.east = (WallSide)ctx.state().getValue((Property)BlockStateProperties.EAST_WALL);
        this.south = (WallSide)ctx.state().getValue((Property)BlockStateProperties.SOUTH_WALL);
        this.west = (WallSide)ctx.state().getValue((Property)BlockStateProperties.WEST_WALL);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        if (this.north != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.NORTH, this.north);
        }
        if (this.south != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.SOUTH, this.south);
        }
        if (this.east != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.EAST, this.east);
        }
        if (this.west != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.WEST, this.west);
        }
        FramedWallGeometry.buildWallEndCap(quadMap, quad, Direction.NORTH, this.north);
        FramedWallGeometry.buildWallEndCap(quadMap, quad, Direction.EAST, this.east);
        FramedWallGeometry.buildWallEndCap(quadMap, quad, Direction.SOUTH, this.south);
        FramedWallGeometry.buildWallEndCap(quadMap, quad, Direction.WEST, this.west);
        this.buildCenterPillar(quadMap, quad);
    }

    private void buildWallHalfSegment(QuadMap quadMap, BakedQuad quad, Direction dir, WallSide height) {
        if (height != WallSide.NONE) {
            Direction quadDir = quad.getDirection();
            if (Utils.isY(quadDir)) {
                Vector4f rect = rects[dir.ordinal() - 2 + (this.center ? 4 : 0)];
                boolean inset = height != WallSide.TALL && quadDir != Direction.DOWN;
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(rect.x(), rect.y(), rect.z(), rect.w())).applyIf(Modifiers.setPosition(0.875f), inset).export(quadMap.get(inset ? null : quadDir));
            } else if (quadDir.getAxis() != dir.getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(dir.getOpposite(), this.center ? 0.25f : 0.3125f)).applyIf(Modifiers.cutSideUpDown(false, 0.875f), height != WallSide.TALL).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
            }
        }
    }

    private static void buildWallEndCap(QuadMap quadMap, BakedQuad quad, Direction dir, WallSide height) {
        if (quad.getDirection() == dir && height != WallSide.NONE) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, height == WallSide.TALL ? 1.0f : 0.875f)).export(quadMap.get(dir));
        }
    }

    private void buildCenterPillar(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.center) {
            if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.25f, 0.25f, 0.75f, 0.75f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSide(0.25f, 0.0f, 0.75f, 1.0f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
            }
        } else {
            boolean tall = this.north == WallSide.TALL || this.east == WallSide.TALL || this.south == WallSide.TALL || this.west == WallSide.TALL;
            switch (quadDir) {
                case UP: 
                case DOWN: {
                    boolean inset = !tall && quadDir == Direction.UP;
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.6875f)).applyIf(Modifiers.setPosition(0.875f), inset).export(quadMap.get(inset ? null : quadDir));
                    break;
                }
                case NORTH: {
                    FramedWallGeometry.buildSmallCenterSide(quadMap.get(null), quad, this.north, tall);
                    break;
                }
                case EAST: {
                    FramedWallGeometry.buildSmallCenterSide(quadMap.get(null), quad, this.east, tall);
                    break;
                }
                case SOUTH: {
                    FramedWallGeometry.buildSmallCenterSide(quadMap.get(null), quad, this.south, tall);
                    break;
                }
                case WEST: {
                    FramedWallGeometry.buildSmallCenterSide(quadMap.get(null), quad, this.west, tall);
                }
            }
        }
    }

    private static void buildSmallCenterSide(List<BakedQuad> quadList, BakedQuad quad, WallSide height, boolean tall) {
        if (height == WallSide.NONE) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, tall ? 1.0f : 0.875f)).apply(Modifiers.setPosition(0.6875f)).export(quadList);
        } else if (tall && height == WallSide.LOW) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.875f, 0.6875f, 1.0f)).apply(Modifiers.setPosition(0.6875f)).export(quadList);
        }
    }
}

