/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;

public class FramedDoubleThreewayCornerBlockEntity
extends FramedDoubleBlockEntity {
    public FramedDoubleThreewayCornerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_DOUBLE_FRAMED_THREEWAY_CORNER.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)this.getBlockState().getValue((Property)FramedProperties.TOP);
        Direction side = hit.getDirection();
        Vec3 vec = Utils.fraction(hit.getLocation());
        if (top) {
            if (side == facing || side == Direction.UP || side == facing.getCounterClockWise()) {
                return false;
            }
            if (side == facing.getClockWise()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.x() : vec.z();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                return vec.y() <= 1.0 - hor;
            }
            if (side == facing.getOpposite()) {
                double hor;
                Direction dir = facing.getCounterClockWise();
                double d = hor = Utils.isX(dir) ? vec.x() : vec.z();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                return vec.y() <= 1.0 - hor;
            }
            if (side == Direction.DOWN) {
                boolean secondary;
                boolean bl = Utils.isX(facing) ? vec.x() >= vec.z() : (secondary = vec.z() >= 1.0 - vec.x());
                if (Utils.isPositive(facing)) {
                    secondary = !secondary;
                }
                return secondary;
            }
        } else {
            if (side == facing || side == Direction.DOWN || side == facing.getCounterClockWise()) {
                return false;
            }
            if (side == facing.getClockWise()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.x() : vec.z();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                return vec.y() >= hor;
            }
            if (side == facing.getOpposite()) {
                double hor;
                Direction dir = facing.getCounterClockWise();
                double d = hor = Utils.isX(dir) ? vec.x() : vec.z();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                return vec.y() >= hor;
            }
            if (side == Direction.UP) {
                boolean secondary;
                boolean bl = Utils.isX(facing) ? vec.x() >= vec.z() : (secondary = vec.z() >= 1.0 - vec.x());
                if (Utils.isPositive(facing)) {
                    secondary = !secondary;
                }
                return secondary;
            }
        }
        return false;
    }
}

