/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.systems.gear.GearSet;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public interface WaveModifier
extends CodecProvider<WaveModifier> {
    public static final CodecMap<WaveModifier> CODEC = new CodecMap("Gateway Wave Modifier");

    @Deprecated
    default public void apply(LivingEntity entity) {
    }

    default public void apply(LivingEntity entity, GatewayEntity gate) {
        this.apply(entity);
    }

    public void appendHoverText(Item.TooltipContext var1, Consumer<MutableComponent> var2);

    public static void initCodecs() {
        WaveModifier.register("mob_effect", EffectModifier.CODEC);
        WaveModifier.register("attribute", AttributeModifier.CODEC);
        WaveModifier.register("gear_set", GearSetModifier.CODEC);
        WaveModifier.register("loot_table", LootTableModifier.CODEC);
        CODEC.setDefaultCodec(AttributeModifier.CODEC);
    }

    private static void register(String id, Codec<? extends WaveModifier> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public record EffectModifier(ChancedEffectInstance effect) implements WaveModifier
    {
        public static Codec<EffectModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ChancedEffectInstance.CONSTANT_CODEC.fieldOf("effect").forGetter(EffectModifier::effect)).apply((Applicative)inst, EffectModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity, GatewayEntity gate) {
            int duration = entity instanceof Creeper ? 6000 : Integer.MAX_VALUE;
            entity.addEffect(this.effect.createDeterministic(duration));
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            ArrayList output = new ArrayList();
            PotionContents.addPotionTooltip(Arrays.asList(this.effect.createDeterministic(1)), output::add, (float)1.0f, (float)ctx.tickRate());
            list.accept(Component.literal((String)((Component)output.get(0)).getString()));
        }

        public static EffectModifier create(Holder<MobEffect> effect, int amplifier, boolean ambient, boolean visible) {
            return new EffectModifier(new ChancedEffectInstance(1.0f, effect, StepFunction.constant((float)amplifier), ambient, visible));
        }

        public static EffectModifier create(Holder<MobEffect> effect, int amplifier) {
            return EffectModifier.create(effect, amplifier, false, true);
        }
    }

    public record AttributeModifier(RandomAttributeModifier modifier) implements WaveModifier
    {
        public static Codec<AttributeModifier> CODEC = RandomAttributeModifier.CONSTANT_CODEC.xmap(AttributeModifier::new, AttributeModifier::modifier);

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity, GatewayEntity gate) {
            AttributeInstance inst = entity.getAttribute(this.modifier.attribute());
            if (inst == null) {
                return;
            }
            inst.addPermanentModifier(this.modifier.createDeterministic(Gateways.loc("gateway_random_modifier_" + entity.getRandom().nextInt())));
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(((Attribute)this.modifier.attribute().value()).toComponent(this.modifier.createDeterministic(Gateways.loc("gateway_random_modifier")), ApothicAttributes.getTooltipFlag()));
        }

        public static AttributeModifier create(Holder<Attribute> attribute, AttributeModifier.Operation op, float value) {
            return new AttributeModifier(new RandomAttributeModifier(attribute, op, StepFunction.constant((float)value)));
        }
    }

    public record GearSetModifier(DynamicHolder<GearSet> set) implements WaveModifier
    {
        public static Codec<GearSetModifier> CODEC = RecordCodecBuilder.create((T inst) -> inst.group((App)GearSetRegistry.INSTANCE.holderCodec().fieldOf("gear_set").forGetter(GearSetModifier::set)).apply((Applicative)inst, GearSetModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity, GatewayEntity gate) {
            ((GearSet)this.set.get()).apply(entity);
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"modifier.gateways.gear_set", (Object[])new Object[]{Component.translatable((String)this.set.getId().toLanguageKey("gear_set"))}));
        }

        public static GearSetModifier create(ResourceLocation set) {
            return new GearSetModifier((DynamicHolder<GearSet>)GearSetRegistry.INSTANCE.holder(set));
        }
    }

    public record LootTableModifier(ResourceKey<LootTable> table) implements WaveModifier
    {
        public static Codec<LootTableModifier> CODEC = RecordCodecBuilder.create((T inst) -> inst.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(LootTableModifier::table)).apply((Applicative)inst, LootTableModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity, GatewayEntity gate) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.lootTable = this.table;
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
        }

        public static LootTableModifier create(ResourceKey<LootTable> table) {
            return new LootTableModifier(table);
        }

        public static LootTableModifier createEmpty() {
            return LootTableModifier.create((ResourceKey<LootTable>)BuiltInLootTables.EMPTY);
        }
    }
}

