/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.network;

import com.glodblock.github.glodium.Glodium;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;

public class NetworkHandler {
    protected final List<Supplier<IMessage>> LAZY_INIT = new ArrayList<Supplier<IMessage>>();
    protected final String modid;
    protected PayloadRegistrar registrar;

    public NetworkHandler(String modid) {
        this.modid = modid;
    }

    public void onRegister(RegisterPayloadHandlersEvent event) {
        this.registrar = event.registrar(this.modid);
        this.initPackets();
    }

    protected void registerPacket(Supplier<IMessage> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Packet Constructor is null");
        }
        this.LAZY_INIT.add(factory);
    }

    private void initPackets() {
        for (Supplier<IMessage> factory : this.LAZY_INIT) {
            IMessage instance = factory.get();
            if (instance.isClient()) {
                this.registrar.playToClient(instance.type(), this.codec(factory), IMessage::onMessage);
                continue;
            }
            this.registrar.playToServer(instance.type(), this.codec(factory), IMessage::onMessage);
        }
    }

    protected StreamCodec<? super RegistryFriendlyByteBuf, ? extends IMessage> codec(Supplier<? extends IMessage> factory) {
        return StreamCodec.of((pBuffer, pValue) -> pValue.toBytes((RegistryFriendlyByteBuf)pBuffer), pBuffer -> {
            IMessage msg = (IMessage)factory.get();
            msg.fromBytes((RegistryFriendlyByteBuf)pBuffer);
            return msg;
        });
    }

    public void sendToAll(IMessage message) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendTo(IMessage message, ServerPlayer player) {
        player.connection.send((CustomPacketPayload)message);
    }

    public void sendToAllAround(IMessage message, ServerLevel world, BlockPos pos, double r, @Nullable ServerPlayer excludePlayer) {
        MinecraftServer server = Glodium.INSTANCE.getServer();
        if (server != null) {
            PacketDistributor.sendToPlayersNear((ServerLevel)world, (ServerPlayer)excludePlayer, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)r, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToAllAround(IMessage message, ServerLevel world, Position pos, double r, @Nullable ServerPlayer excludePlayer) {
        MinecraftServer server = Glodium.INSTANCE.getServer();
        if (server != null) {
            PacketDistributor.sendToPlayersNear((ServerLevel)world, (ServerPlayer)excludePlayer, (double)pos.x(), (double)pos.y(), (double)pos.z(), (double)r, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToServer(IMessage message) {
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

