/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class IETags {
    private static final Map<TagKey<Block>, TagKey<Item>> toItemTag = new HashMap<TagKey<Block>, TagKey<Item>>();
    private static final Map<EnumMetals, MetalTags> metals = new EnumMap<EnumMetals, MetalTags>(EnumMetals.class);
    public static final TagKey<Item> clay;
    public static final TagKey<Block> clayBlock;
    public static final TagKey<Item> charCoal;
    public static final TagKey<Item> paper;
    public static final TagKey<Block> glowstoneBlock;
    public static final TagKey<Block> copperBlocks;
    public static final TagKey<Block> cutCopperBlocks;
    public static final TagKey<Block> cutCopperStairs;
    public static final TagKey<Block> cutCopperSlabs;
    public static final TagKey<Block> treatedWood;
    public static final TagKey<Block> treatedWoodSlab;
    public static final TagKey<Block> coalCokeBlock;
    public static final TagKey<Block> scaffoldingSteel;
    public static final TagKey<Block> scaffoldingAlu;
    public static final TagKey<Block> scaffoldingSteelStair;
    public static final TagKey<Block> scaffoldingAluStair;
    public static final TagKey<Block> scaffoldingSteelSlab;
    public static final TagKey<Block> scaffoldingAluSlab;
    public static final TagKey<Block> sheetmetals;
    public static final TagKey<Block> sheetmetalSlabs;
    public static final TagKey<Block> fencesSteel;
    public static final TagKey<Block> fencesAlu;
    public static final TagKey<Item> treatedStick;
    public static final TagKey<Item> ironRod;
    public static final TagKey<Item> steelRod;
    public static final TagKey<Item> metalRods;
    public static final TagKey<Item> aluminumRod;
    public static final TagKey<Item> netheriteRod;
    public static final TagKey<Item> netheriteNugget;
    public static final TagKey<Item> seedsHemp;
    public static final TagKey<Item> fiberHemp;
    public static final TagKey<Item> fabricHemp;
    public static final TagKey<Item> coalCoke;
    public static final TagKey<Item> slag;
    public static final TagKey<Item> coalCokeDust;
    public static final TagKey<Item> hopGraphiteDust;
    public static final TagKey<Item> hopGraphiteIngot;
    public static final TagKey<Item> hopGraphitePlate;
    public static final TagKey<Item> copperWire;
    public static final TagKey<Item> electrumWire;
    public static final TagKey<Item> aluminumWire;
    public static final TagKey<Item> steelWire;
    public static final TagKey<Item> leadWire;
    public static final TagKey<Item> allWires;
    public static final TagKey<Item> saltpeterDust;
    public static final TagKey<Item> sulfurDust;
    public static final TagKey<Item> sawdust;
    public static final TagKey<Item> plates;
    public static final TagKey<Item> plasticPlate;
    public static final TagKey<Item> sawblades;
    public static final TagKey<Item> forbiddenInCrates;
    public static final TagKey<Item> circuitPCB;
    public static final TagKey<Item> circuitLogic;
    public static final TagKey<Item> circuitSolder;
    public static final TagKey<Item> hammers;
    public static final TagKey<Item> screwdrivers;
    public static final TagKey<Item> wirecutters;
    public static final TagKey<Item> toolboxTools;
    public static final TagKey<Item> toolboxFood;
    public static final TagKey<Item> toolboxWiring;
    public static final TagKey<Item> connectorInsulator;
    public static final TagKey<Item> repairsAutomaton;
    public static final TagKey<Block> hammerHarvestable;
    public static final TagKey<Block> wirecutterHarvestable;
    public static final TagKey<Block> drillHarvestable;
    public static final TagKey<Block> rockcutterHarvestable;
    public static final TagKey<Block> grindingDiskHarvestable;
    public static final TagKey<Block> surveyToolTargets;
    public static final TagKey<Block> concreteForFeet;
    public static final TagKey<Block> incorrectDropsSteel;
    public static final TagKey<Block> teleportBlocking;
    public static final TagKey<Block> buzzsawTreeBlacklist;
    public static final TagKey<Item> powerpackForbidAttach;
    public static final TagKey<Item> recyclingIgnoredComponents;
    public static final TagKey<Item> recyclingWhitelist;
    public static final TagKey<Item> recyclingBlacklist;
    public static final TagKey<Fluid> fluidCreosote;
    public static final TagKey<Fluid> fluidPlantoil;
    public static final TagKey<Fluid> fluidEthanol;
    public static final TagKey<Fluid> fluidBiodiesel;
    public static final TagKey<Fluid> fluidHighPowerBiodiesel;
    public static final TagKey<Fluid> fluidConcrete;
    public static final TagKey<Fluid> fluidHerbicide;
    public static final TagKey<Fluid> fluidRedstoneAcid;
    public static final TagKey<Fluid> fluidPotion;
    public static final TagKey<Fluid> fluidAcetaldehyde;
    public static final TagKey<Fluid> fluidResin;
    public static final TagKey<Fluid> drillFuel;
    public static final TagKey<EntityType<?>> shaderbagWhitelist;
    public static final TagKey<EntityType<?>> shaderbagBlacklist;
    public static final TagKey<Biome> is_swamp;
    public static final TagKey<Biome> generateClaypan;
    public static final TagKey<Biome> generateSeabed;

    public static TagKey<Item> getItemTag(TagKey<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    public static MetalTags getTagsFor(EnumMetals metal) {
        return metals.get((Object)metal);
    }

    private static TagKey<Block> createBlockTag(ResourceLocation name) {
        TagKey<Block> blockTag = TagUtils.createBlockWrapper(name);
        toItemTag.put(blockTag, TagUtils.createItemWrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<TagKey<Block>, TagKey<Item>> out) {
        for (Map.Entry<TagKey<Block>, TagKey<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static ResourceLocation neoLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)path);
    }

    private static ResourceLocation cLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }

    public static ResourceLocation getOre(String type) {
        return IETags.cLoc("ores/" + type);
    }

    public static ResourceLocation getRawOre(String type) {
        return IETags.cLoc("raw_materials/" + type);
    }

    public static ResourceLocation getNugget(String type) {
        return IETags.cLoc("nuggets/" + type);
    }

    public static ResourceLocation getIngot(String type) {
        return IETags.cLoc("ingots/" + type);
    }

    public static ResourceLocation getGem(String type) {
        return IETags.cLoc("gems/" + type);
    }

    public static ResourceLocation getStorageBlock(String type) {
        return IETags.cLoc("storage_blocks/" + type);
    }

    public static ResourceLocation getRawBlock(String type) {
        return IETags.getStorageBlock("raw_" + type);
    }

    public static ResourceLocation getDust(String type) {
        return IETags.cLoc("dusts/" + type);
    }

    public static ResourceLocation getPlate(String type) {
        return IETags.cLoc("plates/" + type);
    }

    public static ResourceLocation getRod(String type) {
        return IETags.cLoc("rods/" + type);
    }

    public static ResourceLocation getGear(String type) {
        return IETags.cLoc("gears/" + type);
    }

    public static ResourceLocation getWire(String type) {
        return IETags.cLoc("wires/" + type);
    }

    public static ResourceLocation getSheetmetalBlock(String type) {
        return IETags.cLoc("sheetmetals/" + type);
    }

    static {
        toItemTag.put((TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORES, (TagKey<Item>)Tags.Items.ORES);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORES_IN_GROUND_STONE, (TagKey<Item>)Tags.Items.ORES_IN_GROUND_STONE);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, (TagKey<Item>)Tags.Items.ORES_IN_GROUND_DEEPSLATE);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORE_RATES_SINGULAR, (TagKey<Item>)Tags.Items.ORE_RATES_SINGULAR);
        toItemTag.put((TagKey<Block>)BlockTags.PLANKS, (TagKey<Item>)ItemTags.PLANKS);
        toItemTag.put((TagKey<Block>)Tags.Blocks.GRAVELS, (TagKey<Item>)Tags.Items.GRAVELS);
        toItemTag.put((TagKey<Block>)BlockTags.WOODEN_SLABS, (TagKey<Item>)ItemTags.WOODEN_SLABS);
        toItemTag.put((TagKey<Block>)BlockTags.SLABS, (TagKey<Item>)ItemTags.SLABS);
        toItemTag.put((TagKey<Block>)BlockTags.WOODEN_STAIRS, (TagKey<Item>)ItemTags.WOODEN_STAIRS);
        toItemTag.put((TagKey<Block>)BlockTags.STAIRS, (TagKey<Item>)ItemTags.STAIRS);
        toItemTag.put((TagKey<Block>)BlockTags.WOODEN_FENCES, (TagKey<Item>)ItemTags.WOODEN_FENCES);
        toItemTag.put((TagKey<Block>)BlockTags.FENCES, (TagKey<Item>)ItemTags.FENCES);
        toItemTag.put((TagKey<Block>)BlockTags.FENCE_GATES, (TagKey<Item>)ItemTags.FENCE_GATES);
        toItemTag.put((TagKey<Block>)BlockTags.WOODEN_DOORS, (TagKey<Item>)ItemTags.WOODEN_DOORS);
        toItemTag.put((TagKey<Block>)BlockTags.DOORS, (TagKey<Item>)ItemTags.DOORS);
        toItemTag.put((TagKey<Block>)BlockTags.WOODEN_TRAPDOORS, (TagKey<Item>)ItemTags.WOODEN_TRAPDOORS);
        toItemTag.put((TagKey<Block>)BlockTags.TRAPDOORS, (TagKey<Item>)ItemTags.TRAPDOORS);
        clay = TagUtils.createItemWrapper(IETags.cLoc("clay"));
        clayBlock = IETags.createBlockTag(IETags.getStorageBlock("clay"));
        charCoal = TagUtils.createItemWrapper(IETags.cLoc("charcoal"));
        paper = TagUtils.createItemWrapper(IETags.cLoc("paper"));
        glowstoneBlock = IETags.createBlockTag(IETags.getStorageBlock("glowstone"));
        copperBlocks = IETags.createBlockTag(IEApi.ieLoc("blocks/copper"));
        cutCopperBlocks = IETags.createBlockTag(IEApi.ieLoc("cut_blocks/copper"));
        cutCopperStairs = IETags.createBlockTag(IEApi.ieLoc("cut_stairs/copper"));
        cutCopperSlabs = IETags.createBlockTag(IEApi.ieLoc("cut_slabs/copper"));
        treatedWood = IETags.createBlockTag(IEApi.ieLoc("treated_wood"));
        treatedWoodSlab = IETags.createBlockTag(IEApi.ieLoc("treated_wood_slab"));
        coalCokeBlock = IETags.createBlockTag(IETags.getStorageBlock("coal_coke"));
        scaffoldingSteel = IETags.createBlockTag(IEApi.ieLoc("scaffoldings/steel"));
        scaffoldingAlu = IETags.createBlockTag(IEApi.ieLoc("scaffoldings/aluminum"));
        scaffoldingSteelStair = IETags.createBlockTag(IEApi.ieLoc("scaffolding_stairs/steel"));
        scaffoldingAluStair = IETags.createBlockTag(IEApi.ieLoc("scaffolding_stairs/aluminum"));
        scaffoldingSteelSlab = IETags.createBlockTag(IEApi.ieLoc("scaffolding_slabs/steel"));
        scaffoldingAluSlab = IETags.createBlockTag(IEApi.ieLoc("scaffolding_slabs/aluminum"));
        sheetmetals = IETags.createBlockTag(IETags.cLoc("sheetmetals"));
        sheetmetalSlabs = IETags.createBlockTag(IETags.cLoc("sheetmetal_slabs"));
        fencesSteel = IETags.createBlockTag(IETags.cLoc("fences/steel"));
        fencesAlu = IETags.createBlockTag(IETags.cLoc("fences/aluminum"));
        treatedStick = TagUtils.createItemWrapper(IETags.getRod("treated_wood"));
        ironRod = TagUtils.createItemWrapper(IETags.getRod("iron"));
        steelRod = TagUtils.createItemWrapper(IETags.getRod("steel"));
        metalRods = TagUtils.createItemWrapper(IETags.getRod("all_metal"));
        aluminumRod = TagUtils.createItemWrapper(IETags.getRod("aluminum"));
        netheriteRod = TagUtils.createItemWrapper(IETags.getRod("netherite"));
        netheriteNugget = TagUtils.createItemWrapper(IETags.getNugget("netherite"));
        seedsHemp = TagUtils.createItemWrapper(IETags.cLoc("seeds/hemp"));
        fiberHemp = TagUtils.createItemWrapper(IETags.cLoc("fiber_hemp"));
        fabricHemp = TagUtils.createItemWrapper(IETags.cLoc("fabric_hemp"));
        coalCoke = TagUtils.createItemWrapper(IETags.cLoc("coal_coke"));
        slag = TagUtils.createItemWrapper(IETags.cLoc("slag"));
        coalCokeDust = TagUtils.createItemWrapper(IETags.getDust("coal_coke"));
        hopGraphiteDust = TagUtils.createItemWrapper(IETags.getDust("hop_graphite"));
        hopGraphiteIngot = TagUtils.createItemWrapper(IETags.getIngot("hop_graphite"));
        hopGraphitePlate = TagUtils.createItemWrapper(IETags.getPlate("hop_graphite"));
        copperWire = TagUtils.createItemWrapper(IETags.getWire("copper"));
        electrumWire = TagUtils.createItemWrapper(IETags.getWire("electrum"));
        aluminumWire = TagUtils.createItemWrapper(IETags.getWire("aluminum"));
        steelWire = TagUtils.createItemWrapper(IETags.getWire("steel"));
        leadWire = TagUtils.createItemWrapper(IETags.getWire("lead"));
        allWires = TagUtils.createItemWrapper(IETags.cLoc("wires"));
        saltpeterDust = TagUtils.createItemWrapper(IETags.getDust("saltpeter"));
        sulfurDust = TagUtils.createItemWrapper(IETags.getDust("sulfur"));
        sawdust = TagUtils.createItemWrapper(IETags.getDust("wood"));
        plates = TagUtils.createItemWrapper(IETags.cLoc("plates"));
        plasticPlate = TagUtils.createItemWrapper(IETags.getPlate("plastic"));
        sawblades = TagUtils.createItemWrapper(IETags.cLoc("sawblades"));
        forbiddenInCrates = TagUtils.createItemWrapper(IEApi.ieLoc("forbidden_in_crates"));
        circuitPCB = TagUtils.createItemWrapper(IEApi.ieLoc("circuits/pcb"));
        circuitLogic = TagUtils.createItemWrapper(IEApi.ieLoc("circuits/logic"));
        circuitSolder = TagUtils.createItemWrapper(IEApi.ieLoc("circuits/solder"));
        hammers = TagUtils.createItemWrapper(IEApi.ieLoc("tools/hammers"));
        screwdrivers = TagUtils.createItemWrapper(IEApi.ieLoc("tools/screwdrivers"));
        wirecutters = TagUtils.createItemWrapper(IEApi.ieLoc("tools/wirecutters"));
        toolboxTools = TagUtils.createItemWrapper(IEApi.ieLoc("toolbox/tools"));
        toolboxFood = TagUtils.createItemWrapper(IEApi.ieLoc("toolbox/food"));
        toolboxWiring = TagUtils.createItemWrapper(IEApi.ieLoc("toolbox/wiring"));
        connectorInsulator = TagUtils.createItemWrapper(IEApi.ieLoc("connector_insulator"));
        repairsAutomaton = TagUtils.createItemWrapper(IEApi.ieLoc("repairs_automaton"));
        hammerHarvestable = TagUtils.createBlockWrapper(IEApi.ieLoc("mineable/hammer"));
        wirecutterHarvestable = TagUtils.createBlockWrapper(IEApi.ieLoc("mineable/wirecutter"));
        drillHarvestable = TagUtils.createBlockWrapper(IEApi.ieLoc("mineable/drill"));
        rockcutterHarvestable = TagUtils.createBlockWrapper(IEApi.ieLoc("mineable/rockcutter"));
        grindingDiskHarvestable = TagUtils.createBlockWrapper(IEApi.ieLoc("mineable/grinding_disk"));
        surveyToolTargets = TagUtils.createBlockWrapper(IEApi.ieLoc("survey_tool_targets"));
        concreteForFeet = TagUtils.createBlockWrapper(IEApi.ieLoc("concrete_for_concrete_feet"));
        incorrectDropsSteel = TagUtils.createBlockWrapper(IEApi.ieLoc("incorrect_for_steel_tool"));
        teleportBlocking = TagUtils.createBlockWrapper(IEApi.ieLoc("teleport_blocking"));
        buzzsawTreeBlacklist = TagUtils.createBlockWrapper(IEApi.ieLoc("buzzsaw/tree_blacklist"));
        powerpackForbidAttach = TagUtils.createItemWrapper(IEApi.ieLoc("powerpack/forbid_attach"));
        recyclingIgnoredComponents = TagUtils.createItemWrapper(IEApi.ieLoc("recycling/ignored_components"));
        recyclingWhitelist = TagUtils.createItemWrapper(IEApi.ieLoc("recycling/whitelist"));
        recyclingBlacklist = TagUtils.createItemWrapper(IEApi.ieLoc("recycling/blacklist"));
        fluidCreosote = TagUtils.createFluidWrapper(IETags.cLoc("creosote"));
        fluidPlantoil = TagUtils.createFluidWrapper(IETags.cLoc("plantoil"));
        fluidEthanol = TagUtils.createFluidWrapper(IETags.cLoc("ethanol"));
        fluidBiodiesel = TagUtils.createFluidWrapper(IETags.cLoc("biodiesel"));
        fluidHighPowerBiodiesel = TagUtils.createFluidWrapper(IETags.cLoc("high_power_biodiesel"));
        fluidConcrete = TagUtils.createFluidWrapper(IETags.cLoc("concrete"));
        fluidHerbicide = TagUtils.createFluidWrapper(IETags.cLoc("herbicide"));
        fluidRedstoneAcid = TagUtils.createFluidWrapper(IETags.cLoc("redstone_acid"));
        fluidPotion = TagUtils.createFluidWrapper(IETags.cLoc("potion"));
        fluidAcetaldehyde = TagUtils.createFluidWrapper(IETags.cLoc("acetaldehyde"));
        fluidResin = TagUtils.createFluidWrapper(IETags.cLoc("phenolic_resin"));
        drillFuel = TagUtils.createFluidWrapper(IEApi.ieLoc("drill_fuel"));
        shaderbagWhitelist = TagUtils.createEntityWrapper(IEApi.ieLoc("shaderbag/whitelist"));
        shaderbagBlacklist = TagUtils.createEntityWrapper(IEApi.ieLoc("shaderbag/blacklist"));
        is_swamp = TagUtils.createBiomeWrapper(IETags.cLoc("is_swamp"));
        generateClaypan = TagUtils.createBiomeWrapper(IEApi.ieLoc("generate_hardened_clay_pan"));
        generateSeabed = TagUtils.createBiomeWrapper(IEApi.ieLoc("generate_ancient_seabed"));
        for (EnumMetals m : EnumMetals.values()) {
            metals.put(m, new MetalTags(m));
        }
    }

    public static class MetalTags {
        public final TagKey<Item> ingot;
        public final TagKey<Item> nugget;
        @Nullable
        public final TagKey<Item> rawOre;
        public final TagKey<Item> plate;
        public final TagKey<Item> dust;
        public final TagKey<Block> storage;
        public final TagKey<Block> sheetmetal;
        @Nullable
        public final TagKey<Block> ore;
        @Nullable
        public final TagKey<Block> rawBlock;

        private MetalTags(EnumMetals m) {
            String name = m.tagName();
            TagKey ore = null;
            TagKey<Item> rawOre = null;
            TagKey rawBlock = null;
            if (m.shouldAddOre()) {
                ore = IETags.createBlockTag(IETags.getOre(name));
                rawOre = TagUtils.createItemWrapper(IETags.getRawOre(name));
                rawBlock = IETags.createBlockTag(IETags.getRawBlock(name));
            }
            if (!m.isVanillaMetal()) {
                this.storage = IETags.createBlockTag(IETags.getStorageBlock(name));
            } else if (m == EnumMetals.COPPER) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_COPPER;
                ore = Tags.Blocks.ORES_COPPER;
                rawBlock = Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER;
            } else if (m == EnumMetals.IRON) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_IRON;
                ore = Tags.Blocks.ORES_IRON;
                rawBlock = Tags.Blocks.STORAGE_BLOCKS_RAW_IRON;
            } else if (m == EnumMetals.GOLD) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_GOLD;
                ore = Tags.Blocks.ORES_GOLD;
                rawBlock = Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD;
            } else {
                throw new RuntimeException("Unkown vanilla metal: " + m.name());
            }
            this.sheetmetal = IETags.createBlockTag(IETags.getSheetmetalBlock(name));
            this.nugget = TagUtils.createItemWrapper(IETags.getNugget(name));
            this.ingot = TagUtils.createItemWrapper(IETags.getIngot(name));
            this.plate = TagUtils.createItemWrapper(IETags.getPlate(name));
            this.dust = TagUtils.createItemWrapper(IETags.getDust(name));
            this.ore = ore;
            this.rawOre = rawOre;
            this.rawBlock = rawBlock;
        }
    }
}

