/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.conveyor;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorCacheData;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.conveyor.BasicConveyorRender;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ExtractConveyor;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class ExtractConveyorRender
extends BasicConveyorRender<ExtractConveyor> {
    public ExtractConveyorRender(ResourceLocation active, ResourceLocation inactive) {
        super(active, inactive);
    }

    @Override
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, IConveyorModelRender.RenderContext<ExtractConveyor> context, @Nullable RenderType renderType) {
        int i;
        if (renderType != null && renderType != RenderType.cutout()) {
            return super.modifyQuads(baseModel, context, renderType);
        }
        TextureAtlasSprite texture_steel = ClientUtils.getSprite(IEApi.ieLoc("block/metal/storage_steel"));
        TextureAtlasSprite texture_casing = ClientUtils.getSprite(IEApi.ieLoc("block/wooden_device/turntable_bottom"));
        TextureAtlasSprite texture_curtain = ClientUtils.getSprite(IEApi.ieLoc("block/stripcurtain"));
        TextureAtlasSprite texture_assembler = ClientUtils.getSprite(IEApi.ieLoc("block/multiblocks/assembler"));
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        ExtractConveyor instance = context.instance();
        Matrix4 matrix = new Matrix4(instance == null ? Direction.SOUTH : instance.getExtractDirection());
        Transformation tMatrix = matrix.toTransformationMatrix();
        double extend = instance == null ? 0.0 : instance.getCurrentExtension();
        Function<Direction, TextureAtlasSprite> getCasingSprite = enumFacing -> enumFacing.getAxis() == Direction.Axis.Z ? texture_steel : texture_casing;
        Function<Vec3[], Vec3[]> vertexTransformer = vertices -> {
            if (extend == 0.0) {
                return vertices;
            }
            Vec3[] ret = new Vec3[((Vec3[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vec3(vertices[i].x, vertices[i].y, vertices[i].z - extend);
            }
            return ret;
        };
        Function<Vec3[], Vec3[]> casingTransformer = vertices -> {
            Vec3[] ret = new Vec3[((Vec3[])vertices).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Vec3(vertices[i].x, vertices[i].y - 0.25, vertices[i].z - 0.625 - extend);
            }
            return ret;
        };
        Direction facing = context.getFacing();
        baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0625, 0.375, 0.625), new Vec3(0.1875, 1.0, 1.0), matrix, facing, casingTransformer, getCasingSprite, colour));
        baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.8125, 0.375, 0.625), new Vec3(0.9375, 1.0, 1.0), matrix, facing, casingTransformer, getCasingSprite, colour));
        baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.1875, 0.875, 0.625), new Vec3(0.8125, 1.0, 1.0), matrix, facing, casingTransformer, getCasingSprite, colour));
        if (extend > 0.0) {
            TextureAtlasSprite tex_conveyor = ClientUtils.getSprite(instance.isActive() ? ConveyorBase.texture_on : ConveyorBase.texture_off);
            Function<Direction, TextureAtlasSprite> getExtensionSprite = enumFacing -> enumFacing.getAxis() == Direction.Axis.Y ? null : (enumFacing.getAxis() == Direction.Axis.Z ? texture_steel : texture_casing);
            Vec3[] vertices2 = new Vec3[]{new Vec3(0.0625, 0.0, -extend), new Vec3(0.0625, 0.0, 0.0), new Vec3(0.9375, 0.0, 0.0), new Vec3(0.9375, 0.0, -extend)};
            baseModel.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(tMatrix, vertices2), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_conveyor, new double[]{15.0, extend * 16.0, 1.0, 0.0}, colour, true));
            for (int i2 = 0; i2 < vertices2.length; ++i2) {
                vertices2[i2] = Utils.withCoordinate(vertices2[i2], Direction.Axis.Y, 0.125);
            }
            baseModel.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(tMatrix, vertices2), Utils.rotateFacingTowardsDir(Direction.UP, facing), tex_conveyor, new double[]{15.0, (1.0 - extend) * 16.0, 1.0, 16.0}, colour, false));
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3(0.0625, 0.25, 0.625), new Vec3(0.9375, 0.375, 0.625 + extend), matrix, facing, casingTransformer, getExtensionSprite, colour));
        }
        Vec3[] vertices3 = new Vec3[]{new Vec3(0.8125, 0.625, 0.03125), new Vec3(0.8125, 0.125, 0.03125), new Vec3(0.1875, 0.125, 0.03125), new Vec3(0.1875, 0.625, 0.03125)};
        baseModel.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(tMatrix, vertexTransformer.apply(vertices3)), Utils.rotateFacingTowardsDir(Direction.NORTH, facing), texture_assembler, new double[]{15.25, 13.25, 12.75, 15.25}, colour, false));
        for (i = 0; i < vertices3.length; ++i) {
            vertices3[i] = Utils.withCoordinate(vertices3[i], Direction.Axis.Z, 0.0625);
        }
        baseModel.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(tMatrix, vertexTransformer.apply(vertices3)), Utils.rotateFacingTowardsDir(Direction.SOUTH, facing), texture_assembler, new double[]{12.75, 13.25, 15.25, 15.25}, colour, true));
        for (i = 0; i < 5; ++i) {
            float off = (float)i * 0.125f;
            baseModel.addAll(ModelUtils.createBakedBox(new Vec3((double)(0.203125f + off), 0.1875, 0.09375), new Vec3((double)(0.296875f + off), 0.625, 0.125), matrix, facing, vertexTransformer, facing1 -> texture_curtain, colour));
        }
        return super.modifyQuads(baseModel, context, renderType);
    }

    @Override
    public Object getModelCacheKey(IConveyorModelRender.RenderContext<ExtractConveyor> context) {
        BasicConveyorCacheData basic = IConveyorModelRender.getDefaultData(this, context);
        ExtractConveyor instance = context.instance();
        if (instance == null) {
            return basic;
        }
        record Key(BasicConveyorCacheData basic, Direction extractFrom, double extension) {
        }
        return new Key(basic, instance.getExtractDirection(), instance.getCurrentExtension());
    }

    @Override
    public boolean shouldRenderWall(Direction facing, ConveyorWall wall, IConveyorModelRender.RenderContext<ExtractConveyor> context) {
        ExtractConveyor instance = context.instance();
        if (instance == null) {
            return true;
        }
        Direction side = wall.getWallSide(facing);
        return side != instance.getExtractDirection() && super.shouldRenderWall(facing, wall, context);
    }
}

