/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixerLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Quaternionf;

public class MixerRenderer
extends IEMultiblockRenderer<MixerLogic.State> {
    public static final String NAME = "mixer_agitator";
    public static DynamicModel AGITATOR;

    @Override
    public void render(IMultiblockContext<MixerLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        MixerLogic.State state = ctx.getState();
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        bufferIn = BERenderUtils.mirror(orientation, matrixStack, bufferIn);
        matrixStack.pushPose();
        Direction front = orientation.front();
        matrixStack.translate(front == Direction.SOUTH || front == Direction.WEST ? -0.5 : 0.5, 0.0, front == Direction.SOUTH || front == Direction.EAST ? 0.5 : -0.5);
        float agitator = state.animation_agitator - (!state.isActive ? 0.0f : (1.0f - partialTicks) * 9.0f);
        matrixStack.mulPose(new Quaternionf().rotateY(agitator * ((float)Math.PI / 180)));
        matrixStack.translate(-0.5, -0.5, -0.5);
        blockRenderer.getModelRenderer().renderModel(matrixStack.last(), bufferIn.getBuffer(RenderType.solid()), null, AGITATOR.get(), 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.solid());
        matrixStack.popPose();
        matrixStack.translate(front == Direction.SOUTH || front == Direction.WEST ? -0.5 : 0.5, -0.625, front == Direction.SOUTH || front == Direction.EAST ? 0.5 : -0.5);
        matrixStack.scale(0.0625f, 1.0f, 0.0625f);
        matrixStack.mulPose(new Quaternionf().rotateX(1.5707964f));
        for (int i = state.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = state.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            float yy = (float)fs.getAmount() / (float)state.tank.getCapacity() * 1.0625f;
            matrixStack.translate(0.0f, 0.0f, -yy);
            float w = i < state.tank.getFluidTypes() - 1 || (double)yy >= 0.125 ? 26.0f : 16.0f + yy / 0.0125f;
            GuiHelper.drawRepeatedFluidSprite(bufferIn.getBuffer(RenderType.translucent()), matrixStack, fs, -w / 2.0f, -w / 2.0f, w, w);
        }
        matrixStack.popPose();
    }
}

