/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.Lazy;

@OnlyIn(value=Dist.CLIENT)
public final class SpacerComponent
implements Component {
    private final String widthGlyph;
    private final List<Component> siblings = Lists.newArrayList();
    private final Lazy<FormattedCharSequence> formatted = Lazy.of(() -> Language.getInstance().getVisualOrder((FormattedText)this));

    public SpacerComponent(String widthGlyph) {
        this.widthGlyph = widthGlyph;
    }

    public SpacerComponent append(Component sibling) {
        this.siblings.add(sibling);
        return this;
    }

    @Nonnull
    public Style getStyle() {
        return Style.EMPTY;
    }

    @Nonnull
    public ComponentContents getContents() {
        return PlainTextContents.EMPTY;
    }

    public List<Component> getSiblings() {
        return this.siblings;
    }

    public FormattedCharSequence getVisualOrderText() {
        return (FormattedCharSequence)this.formatted.get();
    }

    public int getSpaceWidth(Font font) {
        return font.width(this.widthGlyph);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SpacerComponent) {
            SpacerComponent otherSpacer = (SpacerComponent)other;
            return this.widthGlyph.equals(otherSpacer.widthGlyph) && this.siblings.equals(otherSpacer.siblings);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.widthGlyph, this.siblings);
    }

    public String toString() {
        return "SpacerComponent[widthGlyph=" + this.widthGlyph + ", siblings=" + String.valueOf(this.siblings) + "]";
    }
}

