/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.gui.MaintenanceKitContainer;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageMaintenanceKit(EquipmentSlot slot, CompoundTag nbt) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageMaintenanceKit> ID = IMessage.createType("maintenance_kit");
    public static final StreamCodec<ByteBuf, MessageMaintenanceKit> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper(i -> EquipmentSlot.values()[i], Enum::ordinal), MessageMaintenanceKit::slot, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, MessageMaintenanceKit::nbt, MessageMaintenanceKit::new);

    @Override
    public void process(IPayloadContext context) {
        Player player = context.player();
        context.enqueueWork(() -> {
            if (player.containerMenu instanceof MaintenanceKitContainer) {
                ModWorkbenchBlockEntity.applyConfigTo(((Slot)player.containerMenu.slots.get(0)).getItem(), this.nbt);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

