/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.util.KEval;
import snownee.kiwi.util.KUtil;

public class KiwiCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.literal((String)"kiwi");
        builder.then(Commands.literal((String)"dev_env_rules").then(((LiteralArgumentBuilder)Commands.literal((String)"do_not_run_this_if_you_do_not_know_what_it_does").requires(ctx -> ctx.hasPermission(2))).executes(ctx -> KiwiCommand.debugRules((CommandSourceStack)ctx.getSource()))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"fileName", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String fileName = StringArgumentType.getString((CommandContext)ctx, (String)"fileName");
            if (KiwiConfigManager.refresh(fileName)) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.kiwi.reload.success", (Object[])new Object[]{fileName}), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"commands.kiwi.reload.failed", (Object[])new Object[]{fileName}));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"eval").requires(ctx -> ctx.hasPermission(2))).executes(ctx -> KiwiCommand.evalHelp((CommandSourceStack)ctx.getSource(), CommandSourceStack::sendFailure))).then(Commands.argument((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.eval(StringArgumentType.getString((CommandContext)ctx, (String)"expression"), KiwiCommonConfig.evalPrintExpression, (CommandSourceStack)ctx.getSource(), (source, msg) -> source.sendSuccess(() -> msg, false), CommandSourceStack::sendFailure))));
        dispatcher.register(builder);
    }

    private static int debugRules(CommandSourceStack commandSourceStack) {
        Commands commands = commandSourceStack.getServer().getCommands();
        List<String> rules = List.of("gamerule doDaylightCycle false", "gamerule doWeatherCycle false", "gamerule doMobLoot false", "gamerule doMobSpawning false", "gamerule keepInventory true", "gamerule doTraderSpawning false", "gamerule doInsomnia false", "difficulty peaceful", "kill @e[type=!minecraft:player]", "time set day", "weather clear", "gamerule doMobLoot true");
        for (String rule : rules) {
            commands.performPrefixedCommand(commandSourceStack, rule);
        }
        return 1;
    }

    public static <T> int evalHelp(T ctx, BiConsumer<T, Component> send) {
        String url = "https://github.com/Snownee/Kiwi/wiki/Eval-Guide";
        send.accept(ctx, (Component)Component.literal((String)url).withStyle(s -> s.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url))));
        return 0;
    }

    public static <T> int eval(String expString, boolean print, T source, BiConsumer<T, Component> sendSuccess, BiConsumer<T, Component> sendFailure) {
        try {
            EvaluationValue value;
            if (print) {
                sendSuccess.accept(source, (Component)Component.literal((String)(">>> " + expString)).withStyle(ChatFormatting.GREEN));
            }
            String s = (value = new Expression(expString, KEval.config()).evaluate()).isNumberValue() ? new DecimalFormat("###,###.#####").format(value.getNumberValue()) : (value.isExpressionNode() || value.isBinaryValue() ? "[%s]".formatted(new Object[]{value.getDataType()}) : Objects.toString(value.getValue()));
            sendSuccess.accept(source, (Component)KUtil.clickToCopy(Component.literal((String)s)));
            return value.isNullValue() ? 0 : value.getNumberValue().intValue();
        }
        catch (Throwable e) {
            if (!Platform.isProduction()) {
                Kiwi.LOGGER.error(expString, e);
            }
            sendFailure.accept(source, (Component)Component.literal((String)"%s - %s".formatted(e, e.getLocalizedMessage())));
            return 0;
        }
    }
}

