/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeTags;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.mixin.ItemEntityAccess;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record DropItem(PostActionCommonProperties commonProperties, ItemStack itemStack) implements PostAction
{
    public PostActionType<DropItem> type() {
        return PostActionTypes.DROP_ITEM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        BlockState state;
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Vec3 pos = (Vec3)lootParams.get(LootContextParams.ORIGIN);
        Level level = context.level();
        if (recipe instanceof BlockCrushingRecipe && (state = (BlockState)lootParams.get(LootContextParams.BLOCK_STATE)).is(LycheeTags.EXTEND_BOX)) {
            pos = Vec3.atCenterOf((Vec3i)((Vec3i)lootParams.get(LycheeLootContextParams.BLOCK_POS)));
        }
        ItemStack stack = this.getPath().isEmpty() ? this.itemStack.copy() : ItemStack.parseOptional((HolderLookup.Provider)level.registryAccess(), (CompoundTag)CommonProxy.jsonToTag(new JsonPointer(this.getPath().get()).find(context.get(LycheeContextKey.JSON))));
        stack.setCount(stack.getCount() * times);
        if (recipe != null && recipe.getType() == RecipeTypes.BLOCK_EXPLODING) {
            context.get(LycheeContextKey.ITEM).stacksNeedHandle.add(stack);
        } else {
            CommonProxy.dropItemStack(level, pos.x, pos.y, pos.z, stack, $ -> ((ItemEntityAccess)$).setHealth(80));
        }
    }

    @Override
    public Component getDisplayName() {
        return this.itemStack.getHoverName();
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return List.of(this.itemStack);
    }

    public static class Type
    implements PostActionType<DropItem> {
        public static final MapCodec<DropItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(DropItem::commonProperties), (App)LycheeCodecs.NONEMPTY_ITEM_STACK_MAP_CODEC.forGetter(DropItem::itemStack)).apply((Applicative)instance, DropItem::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DropItem> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, DropItem::commonProperties, (StreamCodec)ItemStack.STREAM_CODEC, DropItem::itemStack, DropItem::new);

        @Override
        public MapCodec<DropItem> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, DropItem> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

