/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.client.gui.WrapperRenderElement;
import snownee.lychee.util.VectorExtensions;
import snownee.lychee.util.ui.InputAction;

public class InteractiveRenderElement
extends RenderElement
implements WrapperRenderElement,
GuiEventListener {
    @Nullable
    private final Function<InteractiveRenderElement, ScreenElement> renderable;
    @Nullable
    private @Nullable Supplier<@Nullable List<Component>> onTooltip;
    @Nullable
    private BiPredicate<InputAction, InteractiveRenderElement> onInput;
    private boolean focused;
    private boolean withScissors;
    private boolean hovered;

    public InteractiveRenderElement(Function<InteractiveRenderElement, ScreenElement> renderable) {
        this.renderable = renderable;
    }

    public static InteractiveRenderElement create(ScreenElement element) {
        if (element instanceof InteractiveRenderElement) {
            InteractiveRenderElement interactiveElement = (InteractiveRenderElement)element;
            return interactiveElement;
        }
        InteractiveRenderElement interactiveElement = new InteractiveRenderElement(ignored -> element);
        if (element instanceof RenderElement) {
            RenderElement renderElement = (RenderElement)element;
            ((RenderElement)interactiveElement.at((Vector2fc)renderElement.position)).withSize((Vector2ic)renderElement.size);
            renderElement.at(VectorExtensions.ZERO3F);
        }
        return interactiveElement;
    }

    public InteractiveRenderElement() {
        this.renderable = null;
    }

    public static void produceClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    @Override
    public void render(GuiGraphics graphics) {
        if (this.renderable == null) {
            return;
        }
        boolean withScissors = this.withScissors;
        if (withScissors) {
            Matrix4f matrix = graphics.pose().last().pose();
            Vector3f topLeft = matrix.transformPosition(new Vector3f());
            Vector3f bottomRight = matrix.transformPosition(new Vector3f((float)this.size.x(), (float)this.size.y(), 0.0f));
            graphics.enableScissor((int)topLeft.x(), (int)topLeft.y(), (int)bottomRight.x(), (int)bottomRight.y());
        }
        graphics.pose().pushPose();
        graphics.pose().translate(this.x(), this.y(), this.z());
        this.renderable.apply(this).render(graphics);
        graphics.pose().popPose();
        if (withScissors) {
            graphics.disableScissor();
        }
    }

    public InteractiveRenderElement onTooltip(@Nullable @Nullable Supplier<@Nullable List<Component>> onTooltip) {
        this.onTooltip = onTooltip;
        return this;
    }

    public InteractiveRenderElement onInput(@Nullable @Nullable BiPredicate<InputAction, @Nullable InteractiveRenderElement> onInput) {
        this.onInput = onInput;
        return this;
    }

    public InteractiveRenderElement withScissors(boolean withScissors) {
        this.withScissors = withScissors;
        return this;
    }

    @Nullable
    public List<Component> getTooltip() {
        if (this.onTooltip == null) {
            return null;
        }
        return this.onTooltip.get();
    }

    @Nullable
    public @Nullable BiPredicate<InputAction, @Nullable InteractiveRenderElement> getOnInput() {
        return this.onInput;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.containsMouse(mouseX, mouseY);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.onInput != null && this.hovered && this.onInput.test(InputAction.mousePressed(button, mouseX, mouseY), this)) {
            InteractiveRenderElement.produceClickSound();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.onInput != null && this.onInput.test(InputAction.keyPressed(keyCode, scanCode, modifiers), this);
    }

    @Override
    @Nullable
    public ScreenElement getWrappedElement() {
        return this.renderable == null ? null : this.renderable.apply(this);
    }

    public void updateHoverState(double mouseX, double mouseY) {
        this.hovered = this.isMouseOver(mouseX, mouseY);
    }
}

