/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.rei.display;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.plugin.common.displays.anvil.AnvilRecipe;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import snownee.lychee.compat.recipeviewer.rei.display.LycheeDisplay;
import snownee.lychee.recipes.AnvilCraftingRecipe;

public class AnvilCraftingDisplay
extends DefaultAnvilDisplay
implements LycheeDisplay<AnvilCraftingRecipe> {
    private final RecipeHolder<AnvilCraftingRecipe> lycheeRecipe;

    public AnvilCraftingDisplay(RecipeHolder<AnvilCraftingRecipe> recipeHolder) {
        super(AnvilCraftingDisplay.makeRecipe(recipeHolder));
        this.lycheeRecipe = recipeHolder;
    }

    private static AnvilRecipe makeRecipe(RecipeHolder<AnvilCraftingRecipe> recipeHolder) {
        AnvilCraftingRecipe recipe = (AnvilCraftingRecipe)recipeHolder.value();
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        List right = ingredients.size() == 1 ? List.of() : Stream.of(((Ingredient)ingredients.getLast()).getItems()).map(ItemStack::copy).peek(it -> it.setCount(recipe.materialCost())).toList();
        return new AnvilRecipe(recipeHolder.id(), List.of(((Ingredient)ingredients.getFirst()).getItems()), right, List.of(recipe.getResultItem((HolderLookup.Provider)Objects.requireNonNull(Minecraft.getInstance().level).registryAccess())));
    }

    @Override
    public RecipeHolder<AnvilCraftingRecipe> recipe() {
        return this.lycheeRecipe;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        List<EntryIngredient> ingredients = LycheeDisplay.super.getOutputEntries();
        ingredients.addAll(0, super.getOutputEntries());
        return ingredients;
    }
}

