/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.Contextual;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record And(ContextualHolder conditions) implements ContextualCondition,
Contextual
{
    public ContextualConditionType<And> type() {
        return ContextualConditionType.AND;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.conditions.test(recipe, ctx, times);
    }

    @Override
    public TriState testForTooltips(Level level, @Nullable Player player) {
        TriState finalResult = TriState.TRUE;
        for (ContextualCondition condition : this.conditions) {
            TriState result = condition.testForTooltips(level, player);
            if (result == TriState.FALSE) {
                return result;
            }
            if (result.get()) continue;
            finalResult = TriState.DEFAULT;
        }
        return finalResult;
    }

    @Override
    public void appendToTooltips(List<Component> tooltips, Level level, @Nullable Player player, int indent, boolean inverted) {
        ContextualCondition.super.appendToTooltips(tooltips, level, player, indent, inverted);
        for (ContextualCondition condition : this.conditions) {
            condition.appendToTooltips(tooltips, level, player, indent + 1, false);
        }
    }

    @Override
    public int showingCount() {
        return this.conditions.showingCount();
    }

    public static class Type
    implements ContextualConditionType<And> {
        public static final MapCodec<And> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ContextualHolder.CODEC.fieldOf("contextual").forGetter(And::conditions)).apply((Applicative)instance, And::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, And> STREAM_CODEC = ContextualHolder.STREAM_CODEC.map(And::new, And::conditions);

        @Override
        public MapCodec<And> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, And> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

