/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeTags;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.network.SCustomLevelEventPacket;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.LycheeFallingBlockEntity;
import snownee.lychee.util.RecipeMatcher;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;
import snownee.lychee.util.recipe.ValidItemCache;

public class BlockCrushingRecipeType
extends BlockKeyableRecipeType<BlockCrushingRecipe> {
    private final ValidItemCache validItems = new ValidItemCache();

    public BlockCrushingRecipeType(String name, Class<BlockCrushingRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    public void process(FallingBlockEntity entity) {
        boolean matched;
        if (this.isEmpty()) {
            return;
        }
        BlockPos pos = CommonProxy.getOnPos((Entity)entity);
        BlockState fallingBlock = entity.getBlockState();
        List recipes = this.recipesByBlock.getOrDefault(fallingBlock.getBlock(), Collections.emptyList());
        if (recipes.isEmpty()) {
            return;
        }
        AABB box = entity.getBoundingBox();
        Level level = entity.level();
        BlockState landingBlock = level.getBlockState(pos);
        if (landingBlock.is(LycheeTags.EXTEND_BOX)) {
            box = box.minmax(new AABB(pos));
        }
        List itemEntities = entity.level().getEntitiesOfClass(ItemEntity.class, box, $ -> $.isAlive() && this.validItems.contains($.getItem()));
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, entity.level());
        ItemShapelessContext itemShapelessContext = new ItemShapelessContext(itemEntities, context);
        context.put(LycheeContextKey.ITEM_SHAPELESS, itemShapelessContext);
        Optional<RecipeMatcher<ItemStack>> matcher = itemShapelessContext.getMatcher();
        LootParamsContext lootParams = context.initLootParams(this);
        lootParams.set(LootContextParams.ORIGIN, entity.position());
        lootParams.set(LootContextParams.THIS_ENTITY, entity);
        lootParams.set(LootContextParams.BLOCK_STATE, landingBlock);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
        lootParams.validate();
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        boolean matchedAny = false;
        int loop = 0;
        block2: do {
            matched = false;
            for (RecipeHolder recipe : recipes) {
                if (((BlockCrushingRecipe)recipe.value()).ingredients.isEmpty() && loop > 0) continue;
                try {
                    Optional match = this.tryMatch(recipe, level, context);
                    if (!match.isPresent()) continue;
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    context.put(recipe);
                    if (matcher.map(it -> it.inputUsed.length > 0).orElse(false).booleanValue()) {
                        int[] inputUsed = matcher.get().inputUsed;
                        times = ((BlockCrushingRecipe)recipe.value()).getRandomRepeats(Integer.MAX_VALUE, context);
                        for (int i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            ItemStack stack = itemShapelessContext.filteredItems.get(i).getItem();
                            times = Math.min(times, stack.getCount() / inputUsed[i]);
                        }
                    }
                    ((BlockCrushingRecipe)match.get().value()).applyPostActions(context, times);
                    if (actionContext.avoidDefault) {
                        ((LycheeFallingBlockEntity)entity).lychee$cancelDrop();
                    }
                    HashSet alreadySentParticles = Sets.newHashSet();
                    ItemStackHolderCollection itemContext = context.get(LycheeContextKey.ITEM);
                    for (ExtendedItemStackHolder holder : itemContext) {
                        ItemStackHolder itemStackHolder;
                        if (holder.getConsumption() <= 0 || holder.get().isEmpty() || !((itemStackHolder = holder.holder()) instanceof ItemStackHolder.Entity)) continue;
                        ItemStackHolder.Entity entityHolder = (ItemStackHolder.Entity)itemStackHolder;
                        if (alreadySentParticles.contains(holder)) continue;
                        alreadySentParticles.add(holder);
                        Vec3 position = entityHolder.getEntity().position();
                        new SCustomLevelEventPacket(holder.get().copy(), position).sendToAround((ServerLevel)entityHolder.getEntity().level());
                    }
                    itemShapelessContext.totalItems -= itemContext.postApply(true, times);
                    if (((BlockCrushingRecipe)recipe.value()).maxRepeats().isAny()) {
                        itemShapelessContext.filteredItems = null;
                        itemShapelessContext.setMatcher(null);
                        itemShapelessContext.itemEntities.removeIf($ -> $.getItem().isEmpty());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            BlockState state = level.getBlockState(entity.blockPosition());
            if (!FallingBlock.isFree((BlockState)state)) {
                entity.setPosRaw(entity.getX(), (double)(pos.getY() + 1), entity.getZ());
            }
            ((LycheeFallingBlockEntity)entity).lychee$matched();
            itemShapelessContext.itemEntities.forEach($ -> $.setItem($.getItem().copy()));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        super.refreshCache();
        this.validItems.refreshCache(this.recipes);
    }

    @Override
    public Comparator<RecipeHolder<BlockCrushingRecipe>> comparator() {
        return Comparator.comparing(RecipeHolder::value, Comparator.comparingInt($ -> $.getIngredients().size()).thenComparing($ -> !BlockPredicateExtensions.isAny($.landingBlock())).thenComparing($ -> !$.maxRepeats().isAny()).thenComparing(Recipe::isSpecial).reversed());
    }
}

