/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.recipes.EntityTickingRecipeType;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.EntityPredicateExtensions;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class EntityTickingRecipe
extends LycheeRecipe<LycheeContext> {
    private final EntityPredicate predicate;
    private final EntityPredicate withoutTypePredicate;
    private final int interval;

    public EntityTickingRecipe(LycheeRecipeCommonProperties commonProperties, EntityPredicate predicate, int interval) {
        super(commonProperties);
        this.predicate = predicate;
        this.interval = interval;
        this.withoutTypePredicate = EntityPredicateExtensions.withoutType(predicate);
        this.onConstructed();
    }

    public EntityPredicate predicate() {
        return this.predicate;
    }

    public EntityPredicate withoutTypePredicate() {
        return this.withoutTypePredicate;
    }

    public int interval() {
        return this.interval;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        return true;
    }

    @Override
    public LycheeRecipeSerializer<EntityTickingRecipe> getSerializer() {
        return RecipeSerializers.ENTITY_TICKING;
    }

    @Override
    public EntityTickingRecipeType getType() {
        return RecipeTypes.ENTITY_TICKING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<EntityTickingRecipe> {
        public static final MapCodec<EntityTickingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)EntityPredicate.CODEC.fieldOf("entity").validate(it -> {
            if (it.entityType().isEmpty() || ((EntityTypePredicate)it.entityType().get()).types().size() == 0) {
                return DataResult.error(() -> "EntityPredicate must have at least one entity type");
            }
            return DataResult.success((Object)it);
        }).forGetter(EntityTickingRecipe::predicate), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("interval", (Object)1).forGetter(EntityTickingRecipe::interval)).apply((Applicative)instance, EntityTickingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EntityTickingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)EntityPredicate.CODEC), EntityTickingRecipe::predicate, (StreamCodec)ByteBufCodecs.VAR_INT, EntityTickingRecipe::interval, EntityTickingRecipe::new);

        @Override
        public MapCodec<EntityTickingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, EntityTickingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

