/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.recipes.RandomBlockTickingRecipe;
import snownee.lychee.util.RandomlyTickable;
import snownee.lychee.util.predicates.BlockStateSet;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;

public class RandomBlockTickingRecipeType
extends BlockKeyableRecipeType<RandomBlockTickingRecipe> {
    public RandomBlockTickingRecipeType(String name, Class<RandomBlockTickingRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        boolean prevEmpty = this.isEmpty();
        super.refreshCache();
        if (prevEmpty && this.recipes.isEmpty()) {
            return;
        }
        Predicate<BlockState> predicate = this.anyBlockRecipes.isEmpty() ? BlockStateSet.NONE : BlockStateSet.ANY;
        for (Block block : BuiltInRegistries.BLOCK) {
            ((RandomlyTickable)block).lychee$setTickable(predicate);
        }
        if (this.anyBlockRecipes.isEmpty()) {
            for (Map.Entry entry : this.recipesByBlock.entrySet()) {
                Block block = (Block)entry.getKey();
                Stream<BlockPredicate> stream = ((List)entry.getValue()).stream().map(RecipeHolder::value).map(RandomBlockTickingRecipe::blockPredicate);
                ((RandomlyTickable)block).lychee$setTickable(BlockStateSet.of(block, stream));
            }
        }
    }
}

