/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.RecipeMatcher;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class ItemShapelessRecipeUtils {
    public static final int MAX_INGREDIENTS = 27;

    public static boolean matches(LycheeContext context, IngredientCollection ingredients) {
        ItemShapelessContext itemShapelessContext = context.get(LycheeContextKey.ITEM_SHAPELESS);
        if (itemShapelessContext.totalItems < ingredients.size()) {
            return false;
        }
        if (ingredients.isEmpty()) {
            return true;
        }
        List<ItemEntity> itemEntities = itemShapelessContext.itemEntities.stream().filter($ -> ingredients.anyMatch($.getItem())).limit(27L).toList();
        List<ItemStack> items = itemEntities.stream().map(ItemEntity::getItem).toList();
        int[] amount = items.stream().mapToInt(ItemStack::getCount).toArray();
        Optional<RecipeMatcher<ItemStack>> match = RecipeMatcher.findMatches(items, ingredients.flattenedIngredients(), amount);
        if (match.isEmpty()) {
            return false;
        }
        itemShapelessContext.filteredItems = itemEntities;
        itemShapelessContext.setMatcher(match.get());
        return true;
    }

    public static <T extends ILycheeRecipe<?>> MapCodec<T> validatedCodec(MapCodec<T> codec) {
        return codec.validate(it -> {
            if (!it.ghost() && it.getIngredients().size() > 27) {
                return DataResult.error(() -> "Ingredients cannot be more than 27");
            }
            return DataResult.success((Object)it);
        });
    }
}

