/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.mixin.EntityAccess;

public class CachedRenderingEntity<T extends Entity> {
    protected T entity;
    protected float scale = 15.0f;
    protected Vector3f translation = new Vector3f(0.0f, 0.0f, 20.0f);
    private Function<Level, T> factory;

    protected CachedRenderingEntity(T entity) {
        this.setEntity(entity);
    }

    protected CachedRenderingEntity(Function<Level, T> factory) {
        this.factory = factory;
    }

    public static <T extends Entity> CachedRenderingEntity<T> of(T entity) {
        return new CachedRenderingEntity<T>(entity);
    }

    public static <T extends Entity> CachedRenderingEntity<T> ofFactory(Function<Level, T> factory) {
        return new CachedRenderingEntity<T>(factory);
    }

    private void ensureEntity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull((Entity)this.factory.apply((Level)Minecraft.getInstance().level));
            this.factory = null;
        }
    }

    public T getEntity() {
        this.ensureEntity();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ((Entity)this.entity).tickCount = player.tickCount;
        }
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
        this.factory = null;
        ((EntityAccess)entity).callSetLevel(null);
    }

    public void earlySetLevel() {
        this.ensureEntity();
        ((EntityAccess)this.entity).callSetLevel((Level)Objects.requireNonNull(Minecraft.getInstance().level));
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void render(PoseStack matrixStack, Quaternionf rotation) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        this.ensureEntity();
        ((EntityAccess)this.entity).callSetLevel((Level)mc.level);
        ((Entity)this.entity).tickCount = (int)(mc.level.getGameTime() % 240000L);
        Vec3 position = mc.gameRenderer.getMainCamera().getPosition();
        this.entity.setPosRaw(position.x(), position.y(), position.z());
        matrixStack.pushPose();
        matrixStack.translate(this.translation.x, this.translation.y, this.translation.z);
        matrixStack.scale(this.scale, this.scale, this.scale);
        matrixStack.mulPose(rotation);
        EntityRenderDispatcher renderDispatcher = mc.getEntityRenderDispatcher();
        rotation.conjugate();
        renderDispatcher.overrideCameraOrientation(rotation);
        renderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        renderDispatcher.render(this.entity, 0.0, 0.0, 0.0, mc.getTimer().getGameTimeDeltaPartialTick(true), 1.0f, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.endBatch();
        renderDispatcher.setRenderShadow(true);
        matrixStack.popPose();
        ((EntityAccess)this.entity).callSetLevel(null);
        ILightingSettings.DEFAULT_3D.applyLighting();
    }
}

