/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mekanism.api.RelativeSide;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRadialSelector;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.armor.ISpecialGear;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.client.render.hud.RadiationOverlay;
import mekanism.client.render.lib.Outlines;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeCustomSelectionBox;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderTickHandler {
    public static final Minecraft minecraft = Minecraft.getInstance();
    private static final Map<BlockState, List<Outlines.Line>> cachedWireFrames = new Reference2ObjectOpenHashMap();
    private static final Map<Direction, Map<TransmissionType, MekanismRenderer.Model3D>> cachedOverlays = new EnumMap<Direction, Map<TransmissionType, MekanismRenderer.Model3D>>(Direction.class);
    private static final List<LazyRender> transparentRenderers = new ArrayList<LazyRender>();
    private static final BoltRenderer boltRenderer = new BoltRenderer();
    private static final Map<Class<?>, Boolean> IS_EMI_SCREEN = new HashMap();
    private boolean outliningArea = false;

    public static void clearQueued() {
        RadiationOverlay.INSTANCE.resetRadiation();
        transparentRenderers.clear();
    }

    public static void resetCached() {
        cachedOverlays.clear();
        cachedWireFrames.clear();
    }

    public static void renderBolt(Object renderer, BoltEffect bolt) {
        boltRenderer.update(renderer, bolt, MekanismRenderer.getPartialTick());
    }

    public static void guiOpening(ScreenEvent.Opening event) {
        Screen screen = event.getCurrentScreen();
        if (screen instanceof GuiMekanism) {
            GuiMekanism screen2 = (GuiMekanism)screen;
            if (Mekanism.hooks.jei.isLoaded() && event.getNewScreen() instanceof IRecipesGui) {
                screen2.switchingToRecipeViewer = true;
            }
            if (Mekanism.hooks.emi.isLoaded() && RenderTickHandler.isEmiScreen(event.getNewScreen())) {
                screen2.switchingToRecipeViewer = true;
            }
        }
    }

    private static boolean isEmiScreen(@Nullable Screen newScreen) {
        return newScreen != null && IS_EMI_SCREEN.computeIfAbsent(newScreen.getClass(), cl -> {
            if (cl.getName().startsWith("dev.emi.emi")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }) == Boolean.TRUE;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderPostHighest(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof GuiMekanism) {
            PoseStack pose = event.getGuiGraphics().pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, (float)GuiMekanism.maxZOffset);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderPostLowest(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof GuiMekanism) {
            event.getGuiGraphics().pose().popPose();
        }
    }

    public static void addTransparentRenderer(LazyRender render) {
        transparentRenderers.add(render);
    }

    @SubscribeEvent
    public void renderWorld(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            if (!transparentRenderers.isEmpty()) {
                Camera camera = event.getCamera();
                MultiBufferSource.BufferSource renderer = minecraft.renderBuffers().bufferSource();
                PoseStack poseStack = event.getPoseStack();
                int renderTick = event.getRenderTick();
                float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
                ProfilerFiller profiler = minecraft.getProfiler();
                profiler.push("delayedMekanismTranslucentBERs");
                if (transparentRenderers.size() == 1) {
                    LazyRender lazyRender = transparentRenderers.getFirst();
                    RenderTickHandler.doTransparentRender(lazyRender.getRenderType(), lazyRender, camera, renderer, poseStack, renderTick, partialTick, profiler);
                } else {
                    for (LazyRender render : transparentRenderers) {
                        Vec3 renderPos = render.getCenterPos(partialTick);
                        render.distance = camera.getPosition().distanceToSqr(renderPos);
                    }
                    transparentRenderers.sort(Comparator.comparingDouble(info -> -info.distance));
                    for (LazyRender render : transparentRenderers) {
                        RenderTickHandler.doTransparentRender(render.getRenderType(), render, camera, renderer, poseStack, renderTick, partialTick, profiler);
                    }
                }
                renderer.endBatch();
                transparentRenderers.clear();
                profiler.pop();
            }
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && boltRenderer.hasBoltsToRender()) {
            MultiBufferSource.BufferSource renderer = minecraft.renderBuffers().bufferSource();
            boltRenderer.render(event.getPartialTick().getGameTimeDeltaPartialTick(false), event.getPoseStack(), (MultiBufferSource)renderer, event.getCamera().getPosition());
            renderer.endBatch(MekanismRenderType.MEK_LIGHTNING);
        }
    }

    @SubscribeEvent
    public void renderCrosshair(RenderGuiLayerEvent.Pre event) {
        GuiRadialSelector screen;
        Screen screen2;
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR) && (screen2 = RenderTickHandler.minecraft.screen) instanceof GuiRadialSelector && (screen = (GuiRadialSelector)screen2).shouldHideCrosshair()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderArm(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chestStack.getItem();
        if (item instanceof ItemMekaSuitArmor) {
            boolean rightHand;
            ItemMekaSuitArmor armorItem = (ItemMekaSuitArmor)item;
            MekaSuitArmor armor = (MekaSuitArmor)((ISpecialGear)IClientItemExtensions.of((Item)armorItem)).gearModel();
            PlayerRenderer renderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
            PlayerModel model = (PlayerModel)renderer.getModel();
            model.setAllVisible(true);
            boolean bl = rightHand = event.getArm() == HumanoidArm.RIGHT;
            if (rightHand) {
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
            } else {
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
            }
            model.attackTime = 0.0f;
            model.crouching = false;
            model.swimAmount = 0.0f;
            model.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            armor.renderArm((HumanoidModel<? extends LivingEntity>)model, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), OverlayTexture.NO_OVERLAY, (LivingEntity)player, chestStack, rightHand);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void tickEnd(ClientTickEvent.Post event) {
        Level world;
        if (RenderTickHandler.minecraft.player != null && (world = RenderTickHandler.minecraft.player.level()) != null && RenderTickHandler.minecraft.gameMode != null && MekanismRenderer.isRunningNormally()) {
            float partialTicks = minecraft.getTimer().getGameTimeDeltaPartialTick(false);
            for (Player p : world.players()) {
                if (Mekanism.playerState.isJetpackOn(p)) {
                    this.doJetpackRender(p, world, partialTicks);
                }
                if (world.getGameTime() % 4L != 0L) continue;
                if (Mekanism.playerState.isScubaMaskOn(p) && p.isInWater()) {
                    RenderTickHandler.doScubaRender(p, world);
                }
                if (p.swinging) continue;
                if (p.isUsingItem()) {
                    InteractionHand usedHand = p.getUsedItemHand();
                    if (p.getItemInHand(usedHand).getItem() instanceof ItemFlamethrower) continue;
                    RenderTickHandler.tryAddIdleFlamethrowerParticles(minecraft, p, usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    continue;
                }
                if (RenderTickHandler.tryAddIdleFlamethrowerParticles(minecraft, p, InteractionHand.MAIN_HAND)) continue;
                RenderTickHandler.tryAddIdleFlamethrowerParticles(minecraft, p, InteractionHand.OFF_HAND);
            }
        }
    }

    private static void doScubaRender(Player p, Level world) {
        Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(p.getViewVector(1.0f)).translate(0.0, -0.2, 0.0);
        Pos3D motion = vec.scale(0.2).translate(p.getDeltaMovement());
        Pos3D v = new Pos3D((Entity)p).translate(0.0, p.getEyeHeight(), 0.0).translate((Vec3)vec);
        world.addParticle((ParticleOptions)MekanismParticleTypes.SCUBA_BUBBLE.get(), v.x, v.y, v.z, motion.x, motion.y + 0.2, motion.z);
    }

    private void doJetpackRender(Player p, Level world, float partialTicks) {
        float xRot;
        Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, p.getEyeHeight(), 0.0);
        Vec3 playerMotion = p.getDeltaMovement();
        float random = (world.random.nextFloat() - 0.5f) * 0.1f;
        if (p.isCrouching()) {
            xRot = 20.0f;
            playerPos = playerPos.translate(0.0, 0.125, 0.0);
        } else {
            float f = p.getSwimAmount(partialTicks);
            if (p.isFallFlying()) {
                float f1 = (float)p.getFallFlyingTicks() + partialTicks;
                float f2 = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                xRot = f2 * (-90.0f - p.getXRot());
            } else {
                float f3 = p.isInWater() ? -90.0f - p.getXRot() : -90.0f;
                xRot = Mth.lerp((float)f, (float)0.0f, (float)f3);
            }
            xRot = -xRot;
            Pos3D eyeAdjustments = p.isFallFlying() && (p != RenderTickHandler.minecraft.player || !RenderTickHandler.minecraft.options.getCameraType().isFirstPerson()) ? new Pos3D(0.0, p.getEyeHeight(Pose.STANDING), 0.0).xRot(xRot).yRot(p.yBodyRot) : (p.isVisuallySwimming() ? new Pos3D(0.0, p.getEyeHeight(), 0.0).xRot(xRot).yRot(p.yBodyRot).translate(0.0, 0.5, 0.0) : new Pos3D(0.0, p.getEyeHeight(), 0.0).xRot(xRot).yRot(p.yBodyRot));
            playerPos = new Pos3D(p.getX() + eyeAdjustments.x, p.getY() + eyeAdjustments.y, p.getZ() + eyeAdjustments.z);
        }
        Pos3D vLeft = new Pos3D(-0.43, -0.55, -0.54).xRot(xRot).yRot(p.yBodyRot);
        this.renderJetpackSmoke(world, playerPos.translate(vLeft, playerMotion), vLeft.scale(0.2).translate(playerMotion, vLeft.scale(random)));
        Pos3D vRight = new Pos3D(0.43, -0.55, -0.54).xRot(xRot).yRot(p.yBodyRot);
        this.renderJetpackSmoke(world, playerPos.translate(vRight, playerMotion), vRight.scale(0.2).translate(playerMotion, vRight.scale(random)));
        Pos3D vCenter = new Pos3D(((double)world.random.nextFloat() - 0.5) * 0.4, -0.86, -0.3).xRot(xRot).yRot(p.yBodyRot);
        this.renderJetpackSmoke(world, playerPos.translate(vCenter, playerMotion), vCenter.scale(0.2).translate(playerMotion));
    }

    private static boolean tryAddIdleFlamethrowerParticles(Minecraft minecraft, Player player, InteractionHand hand) {
        Pos3D flameVec;
        if (!ItemFlamethrower.isIdleFlamethrower(player, hand)) {
            return false;
        }
        Entity vehicle = player.getVehicle();
        boolean rightHanded = MekanismUtils.isRightArm((LivingEntity)player, hand);
        if (minecraft.player == player && minecraft.options.getCameraType().isFirstPerson()) {
            flameVec = new Pos3D(1.0, 1.0, 1.0).multiply(player.getViewVector(minecraft.getTimer().getGameTimeDeltaPartialTick(false))).yRot(rightHanded ? 15.0f : -15.0f).translate(0.0, (double)player.getEyeHeight() - 0.1, 0.0);
        } else {
            double flameXCoord = rightHanded ? -0.2 : 0.2;
            double flameYCoord = 1.0;
            double flameZCoord = 1.2;
            if (player.isCrouching()) {
                flameYCoord -= 0.65;
                flameZCoord -= 0.15;
            } else if (vehicle != null) {
                Vec3 attachmentPoint = player.getVehicleAttachmentPoint(vehicle);
                flameXCoord -= attachmentPoint.x;
                flameYCoord -= attachmentPoint.y + 0.1;
                flameZCoord -= attachmentPoint.z;
            }
            flameVec = new Pos3D(flameXCoord, flameYCoord, flameZCoord).yRot(player.yBodyRot);
        }
        Vec3 motion = vehicle == null ? player.getDeltaMovement() : vehicle.getDeltaMovement();
        Vec3 flameMotion = new Vec3(motion.x(), player.onGround() || vehicle != null ? 0.0 : motion.y(), motion.z());
        Vec3 mergedVec = player.position().add((Vec3)flameVec);
        player.level().addParticle((ParticleOptions)MekanismParticleTypes.JETPACK_FLAME.get(), mergedVec.x, mergedVec.y, mergedVec.z, flameMotion.x, flameMotion.y, flameMotion.z);
        return true;
    }

    @SubscribeEvent
    public void onBlockHover(RenderHighlightEvent.Block event) {
        LocalPlayer player = RenderTickHandler.minecraft.player;
        if (player == null) {
            return;
        }
        BlockHitResult rayTraceResult = event.getTarget();
        if (rayTraceResult.getType() != HitResult.Type.MISS) {
            BlockEntity tile;
            IBlastingItem tool;
            Map<BlockPos, BlockState> blocks;
            Item item;
            ItemStack stack;
            Level world = player.level();
            BlockPos pos = rayTraceResult.getBlockPos();
            MultiBufferSource renderer = event.getMultiBufferSource();
            Camera info = event.getCamera();
            PoseStack matrix = event.getPoseStack();
            ProfilerFiller profiler = world.getProfiler();
            BlockState blockState = world.getBlockState(pos);
            profiler.push("areaMineOutline");
            if (!this.outliningArea && !(stack = player.getMainHandItem()).isEmpty() && (item = stack.getItem()) instanceof IBlastingItem && !(blocks = (tool = (IBlastingItem)item).getBlastedBlocks(world, (Player)player, stack, pos, blockState)).isEmpty()) {
                this.outliningArea = true;
                Vec3 renderView = info.getPosition();
                LevelRenderer levelRenderer = event.getLevelRenderer();
                for (Map.Entry<BlockPos, BlockState> block : blocks.entrySet()) {
                    BlockPos blastingTarget = block.getKey();
                    if (pos.equals((Object)blastingTarget) || ClientHooks.onDrawHighlight((LevelRenderer)levelRenderer, (Camera)info, (HitResult)rayTraceResult.withPosition(blastingTarget), (DeltaTracker)event.getDeltaTracker(), (PoseStack)matrix, (MultiBufferSource)renderer)) continue;
                    levelRenderer.renderHitOutline(matrix, renderer.getBuffer(RenderType.lines()), (Entity)player, renderView.x, renderView.y, renderView.z, blastingTarget, block.getValue());
                }
                this.outliningArea = false;
            }
            profiler.pop();
            boolean shouldCancel = false;
            profiler.push("mekOutline");
            if (!blockState.isAir() && world.getWorldBorder().isWithinBounds(pos)) {
                AttributeCustomSelectionBox customSelectionBox;
                BlockPos mainPos;
                BlockPos actualPos = pos;
                BlockState actualState = blockState;
                if (blockState.is(MekanismBlocks.BOUNDING_BLOCK) && (mainPos = BlockBounding.getMainBlockPos((BlockGetter)world, pos)) != null) {
                    actualPos = mainPos;
                    actualState = world.getBlockState(actualPos);
                }
                if ((customSelectionBox = Attribute.get(actualState, AttributeCustomSelectionBox.class)) != null) {
                    if (customSelectionBox.isJavaModel()) {
                        IWireFrameRenderer wireFrameRenderer;
                        BlockEntityRenderer tileRenderer;
                        tile = WorldUtils.getTileEntity((BlockGetter)world, actualPos);
                        if (tile != null && (tileRenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tile)) instanceof IWireFrameRenderer && (wireFrameRenderer = (IWireFrameRenderer)tileRenderer).hasSelectionBox(actualState)) {
                            matrix.pushPose();
                            Vec3 viewPosition = info.getPosition();
                            matrix.translate((double)actualPos.getX() - viewPosition.x, (double)actualPos.getY() - viewPosition.y, (double)actualPos.getZ() - viewPosition.z);
                            VertexConsumer buffer = renderer.getBuffer(RenderType.lines());
                            if (wireFrameRenderer.isCombined()) {
                                this.renderQuadsWireFrame(actualState, buffer, matrix, world.random);
                            }
                            wireFrameRenderer.renderWireFrame(tile, event.getDeltaTracker().getGameTimeDeltaPartialTick(false), matrix, buffer);
                            matrix.popPose();
                            shouldCancel = true;
                        }
                    } else {
                        matrix.pushPose();
                        Vec3 viewPosition = info.getPosition();
                        matrix.translate((double)actualPos.getX() - viewPosition.x, (double)actualPos.getY() - viewPosition.y, (double)actualPos.getZ() - viewPosition.z);
                        this.renderQuadsWireFrame(actualState, renderer.getBuffer(RenderType.lines()), matrix, world.random);
                        matrix.popPose();
                        shouldCancel = true;
                    }
                }
            }
            profiler.pop();
            ItemStack stack2 = player.getMainHandItem();
            if (!(!stack2.isEmpty() && stack2.getItem() instanceof ItemConfigurator || !(stack2 = player.getOffhandItem()).isEmpty() && stack2.getItem() instanceof ItemConfigurator)) {
                if (shouldCancel) {
                    event.setCanceled(true);
                }
                return;
            }
            profiler.push("configurableMachine");
            ItemConfigurator.ConfiguratorMode state = (ItemConfigurator.ConfiguratorMode)((ItemConfigurator)stack2.getItem()).getMode(stack2);
            if (state.isConfigurating()) {
                ISideConfiguration configurable;
                TileComponentConfig config;
                TransmissionType type = Objects.requireNonNull(state.getTransmission(), "Configurating state requires transmission type");
                tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
                if (tile instanceof ISideConfiguration && (config = (configurable = (ISideConfiguration)tile).getConfig()).supports(type)) {
                    RelativeSide side;
                    Direction face = rayTraceResult.getDirection();
                    ConfigInfo configInfo = config.getConfig(type);
                    if (configInfo != null && configInfo.isSideEnabled(side = RelativeSide.fromDirections(configurable.getDirection(), face))) {
                        Vec3 viewPosition = info.getPosition();
                        matrix.pushPose();
                        matrix.translate((double)pos.getX() - viewPosition.x, (double)pos.getY() - viewPosition.y, (double)pos.getZ() - viewPosition.z);
                        @Nullable MekanismRenderer.Model3D object = this.getOverlayModel(face, type);
                        VertexConsumer buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
                        int argb = MekanismRenderer.getColorARGB(configInfo.getDataType(side).getColor(), 0.6f);
                        if (object != null) {
                            RenderResizableCuboid.renderCube(object, matrix, buffer, argb, 0xF000F0, OverlayTexture.NO_OVERLAY, RenderResizableCuboid.FaceDisplay.FRONT, info, null);
                        }
                        matrix.popPose();
                    }
                }
            }
            profiler.pop();
            if (shouldCancel) {
                event.setCanceled(true);
            }
        }
    }

    private void renderQuadsWireFrame(BlockState state, VertexConsumer buffer, PoseStack matrix, RandomSource rand) {
        List<Outlines.Line> lines = cachedWireFrames.get(state);
        if (lines == null) {
            BakedModel bakedModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
            lines = Outlines.extract(bakedModel, state, rand, ModelData.EMPTY, null);
            cachedWireFrames.put(state, lines);
        }
        PoseStack.Pose pose = matrix.last();
        RenderTickHandler.renderVertexWireFrame(lines, buffer, pose.pose(), pose.normal());
    }

    public static void renderVertexWireFrame(Collection<Outlines.Line> lines, VertexConsumer buffer, Matrix4f pose, Matrix3f poseNormal) {
        Vector4f pos = new Vector4f();
        Vector3f normal = new Vector3f();
        RenderTickHandler.renderVertexWireFrame(lines, buffer, pose, poseNormal, pos, normal);
    }

    public static void renderVertexWireFrame(Collection<Outlines.Line> lines, VertexConsumer buffer, Matrix4f pose, Matrix3f poseNormal, Vector4f pos, Vector3f normal) {
        for (Outlines.Line line : lines) {
            poseNormal.transform(line.nX(), line.nY(), line.nZ(), normal);
            pose.transform(line.x1(), line.y1(), line.z1(), 1.0f, pos);
            buffer.addVertex(pos.x, pos.y, pos.z).setColor(0, 0, 0, 102).setNormal(normal.x, normal.y, normal.z);
            pose.transform(line.x2(), line.y2(), line.z2(), 1.0f, pos);
            buffer.addVertex(pos.x, pos.y, pos.z).setColor(0, 0, 0, 102).setNormal(normal.x, normal.y, normal.z);
        }
    }

    private void renderJetpackSmoke(Level world, Vec3 pos, Vec3 motion) {
        world.addParticle((ParticleOptions)MekanismParticleTypes.JETPACK_FLAME.get(), pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
        world.addParticle((ParticleOptions)MekanismParticleTypes.JETPACK_SMOKE.get(), pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }

    private MekanismRenderer.Model3D getOverlayModel(Direction side, TransmissionType type) {
        Map modelMap = cachedOverlays.computeIfAbsent(side, s -> new EnumMap(TransmissionType.class));
        MekanismRenderer.Model3D model = (MekanismRenderer.Model3D)modelMap.get(type);
        if (model == null) {
            model = new MekanismRenderer.Model3D().setTexture(MekanismRenderer.overlays.get(type)).prepSingleFaceModelSize(side);
            modelMap.put(type, model);
        }
        return model;
    }

    private static void doTransparentRender(RenderType renderType, LazyRender transparentRender, Camera camera, MultiBufferSource.BufferSource renderer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
        VertexConsumer buffer = renderer.getBuffer(renderType);
        String profilerSection = transparentRender.getProfilerSection();
        profiler.push(profilerSection);
        transparentRender.render(camera, buffer, poseStack, renderTick, partialTick, profiler);
        profiler.pop();
    }

    public static abstract class LazyRender {
        public double distance;

        public abstract void render(Camera var1, VertexConsumer var2, PoseStack var3, int var4, float var5, ProfilerFiller var6);

        @NotNull
        public abstract Vec3 getCenterPos(float var1);

        @NotNull
        public abstract String getProfilerSection();

        @NotNull
        public abstract RenderType getRenderType();
    }
}

