/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import mekanism.api.MekanismAPITags;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public record ModuleInhalationPurificationUnit(boolean beneficialEffects, boolean neutralEffects, boolean harmfulEffects) implements ICustomModule<ModuleInhalationPurificationUnit>
{
    private static final ICustomModule.ModuleDamageAbsorbInfo INHALATION_ABSORB_INFO = new ICustomModule.ModuleDamageAbsorbInfo(MekanismConfig.gear.mekaSuitMagicDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageMagicReduce);
    public static final ResourceLocation BENEFICIAL_EFFECTS = Mekanism.rl("purification.beneficial");
    public static final ResourceLocation NEUTRAL_EFFECTS = Mekanism.rl("purification.neutral");
    public static final ResourceLocation HARMFUL_EFFECTS = Mekanism.rl("purification.harmful");

    public ModuleInhalationPurificationUnit(IModule<ModuleInhalationPurificationUnit> module) {
        this(module.getBooleanConfigOrFalse(BENEFICIAL_EFFECTS), module.getBooleanConfigOrFalse(NEUTRAL_EFFECTS), module.getBooleanConfigOrFalse(HARMFUL_EFFECTS));
    }

    @Override
    public void tickClient(IModule<ModuleInhalationPurificationUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        if (!player.isSpectator()) {
            long energy;
            long usage = MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
            boolean free = usage == 0L || player.isCreative();
            long l = energy = free ? 0L : module.getContainerEnergy(stack);
            if (free || energy >= usage) {
                List<MobEffectInstance> effects = player.getActiveEffects().stream().filter(this::canHandle).toList();
                for (MobEffectInstance effect : effects) {
                    if (free) {
                        this.speedupEffect(player, effect);
                        continue;
                    }
                    this.speedupEffect(player, effect);
                    if ((energy -= usage) >= usage) continue;
                    break;
                }
            }
        }
    }

    @Override
    public void tickServer(IModule<ModuleInhalationPurificationUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        IEnergyContainer energyContainer;
        long usage = MekanismConfig.gear.mekaSuitEnergyUsagePotionTick.get();
        boolean free = usage == 0L || player.isCreative();
        IEnergyContainer iEnergyContainer = energyContainer = free ? null : module.getEnergyContainer(stack);
        if (free || energyContainer != null && energyContainer.getEnergy() >= usage) {
            List<MobEffectInstance> effects = player.getActiveEffects().stream().filter(this::canHandle).toList();
            for (MobEffectInstance effect : effects) {
                if (free) {
                    this.speedupEffect(player, effect);
                    continue;
                }
                if (module.useEnergy((LivingEntity)player, energyContainer, usage, true) == 0L) break;
                this.speedupEffect(player, effect);
                if (energyContainer.getEnergy() >= usage) continue;
                break;
            }
        }
    }

    @Override
    @Nullable
    public ICustomModule.ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<ModuleInhalationPurificationUnit> module, DamageSource damageSource) {
        return damageSource.is(MekanismAPITags.DamageTypes.IS_PREVENTABLE_MAGIC) ? INHALATION_ABSORB_INFO : null;
    }

    private void speedupEffect(Player player, MobEffectInstance effect) {
        for (int i = 0; i < 9; ++i) {
            MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
        }
    }

    private boolean canHandle(MobEffectInstance effectInstance) {
        boolean bl;
        block8: {
            block7: {
                if (!MekanismUtils.shouldSpeedUpEffect(effectInstance)) break block7;
                switch (((MobEffect)effectInstance.getEffect().value()).getCategory()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BENEFICIAL: {
                        if (this.beneficialEffects) {
                            break;
                        }
                        break block7;
                    }
                    case HARMFUL: {
                        if (this.harmfulEffects) {
                            break;
                        }
                        break block7;
                    }
                    case NEUTRAL: {
                        if (!this.neutralEffects) break block7;
                    }
                }
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }
}

