/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.collection;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BiLongMultimap<V> {
    private final Long2ObjectSortedMap<Set<V>> map = new Long2ObjectAVLTreeMap();
    private final Map<V, LongSortedSet> reverseMap = new HashMap<V, LongSortedSet>();

    public boolean put(long key, V value) {
        boolean changed1 = ((Set)this.map.computeIfAbsent(key, k -> new HashSet())).add(value);
        return this.reverseMap.computeIfAbsent((LongSortedSet)value, (Function<LongSortedSet, LongSortedSet>)((Function<Object, LongSortedSet>)k -> new LongRBTreeSet())).add(key) || changed1;
    }

    public boolean putAll(LongCollection keys, V value) {
        boolean changed = false;
        LongIterator it = keys.iterator();
        while (it.hasNext()) {
            changed |= this.put(it.nextLong(), value);
        }
        return changed;
    }

    public boolean putAll(long[] keys, V value) {
        boolean changed = false;
        for (long key : keys) {
            changed |= this.put(key, value);
        }
        return changed;
    }

    public boolean remove(long key, V value) {
        Set valueSet = (Set)this.map.get(key);
        boolean remove1 = false;
        if (valueSet != null) {
            remove1 = valueSet.remove(value);
            if (valueSet.isEmpty()) {
                this.map.remove(key);
            }
        }
        boolean remove2 = false;
        LongSet keyset = (LongSet)this.reverseMap.get(value);
        if (keyset != null) {
            remove2 = keyset.remove(key);
            if (keyset.isEmpty()) {
                this.reverseMap.remove(value);
            }
        }
        return remove1 && remove2;
    }

    public boolean removeKey(long key) {
        boolean changed = false;
        for (V value : new ArrayList<V>(this.getValues(key))) {
            LongSet longs = (LongSet)this.reverseMap.get(value);
            if (longs == null) continue;
            changed |= longs.remove(key);
            if (!longs.isEmpty()) continue;
            this.reverseMap.remove(value);
        }
        this.map.remove(key);
        return changed;
    }

    public boolean removeValue(V value) {
        boolean changed = false;
        LongBidirectionalIterator iterator = this.getKeys(value).iterator();
        while (iterator.hasNext()) {
            long key = iterator.nextLong();
            Set vs = (Set)this.map.get(key);
            if (vs == null) continue;
            changed |= vs.remove(value);
            if (!vs.isEmpty()) continue;
            this.map.remove(key);
        }
        this.reverseMap.remove(value);
        return changed;
    }

    public LongSortedSet getAllKeys() {
        return this.map.keySet();
    }

    public Set<V> getValues(long key) {
        return (Set)this.map.get(key);
    }

    public LongSortedSet getKeys(V value) {
        return this.reverseMap.get(value);
    }

    public boolean hasAllKeys(LongCollection keys) {
        return this.getAllKeys().containsAll(keys);
    }

    public void clear() {
        this.map.clear();
        this.reverseMap.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty() && this.reverseMap.isEmpty();
    }
}

