/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import mekanism.common.item.interfaces.IUpgradeItem;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TileComponentUpgrade
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    private static final int UPGRADE_TICKS_REQUIRED = 20;
    private int upgradeTicks;
    private final TileEntityMekanism tile;
    @SyntheticComputerMethod(getter="getInstalledUpgrades")
    private final Map<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
    private final Set<Upgrade> supported;
    private final UpgradeInventorySlot upgradeSlot;
    private final UpgradeInventorySlot upgradeOutputSlot;
    private boolean canCheckUpgrades = true;

    public TileComponentUpgrade(TileEntityMekanism tile) {
        this.tile = tile;
        this.supported = this.tile.getSupportedUpgrade();
        this.upgradeSlot = UpgradeInventorySlot.input(() -> {
            this.tile.onContentsChanged();
            this.canCheckUpgrades = true;
        }, this.supported);
        this.upgradeOutputSlot = UpgradeInventorySlot.output(this.tile);
        this.tile.addComponent(this);
    }

    public void tickServer() {
        if (this.canCheckUpgrades) {
            int upgrades;
            IUpgradeItem upgradeItem;
            Upgrade type;
            Item item;
            ItemStack stack = this.upgradeSlot.getStack();
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof IUpgradeItem && this.supports(type = (upgradeItem = (IUpgradeItem)item).getUpgradeType(stack)) && (upgrades = this.getUpgrades(type)) < type.getMax()) {
                int added;
                if (this.upgradeTicks < 20) {
                    ++this.upgradeTicks;
                    return;
                }
                if (this.upgradeTicks == 20 && (added = this.addUpgrades(type, upgrades, this.upgradeSlot.getCount())) > 0) {
                    MekanismUtils.logMismatchedStackSize(this.upgradeSlot.shrinkStack(added, Action.EXECUTE), added);
                }
            }
            this.upgradeTicks = 0;
            this.canCheckUpgrades = false;
        }
    }

    public UpgradeInventorySlot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    public UpgradeInventorySlot getUpgradeOutputSlot() {
        return this.upgradeOutputSlot;
    }

    public double getScaledUpgradeProgress() {
        return (double)this.upgradeTicks / 20.0;
    }

    public int getUpgrades(Upgrade upgrade) {
        return this.upgrades.getOrDefault(upgrade, 0);
    }

    public int addUpgrades(Upgrade upgrade, int maxAvailable) {
        return this.addUpgrades(upgrade, this.getUpgrades(upgrade), maxAvailable);
    }

    private int addUpgrades(Upgrade upgrade, int installed, int maxAvailable) {
        int toAdd;
        if (installed < upgrade.getMax() && (toAdd = Math.min(upgrade.getMax() - installed, maxAvailable)) > 0) {
            this.upgrades.put(upgrade, installed + toAdd);
            this.tile.recalculateUpgrades(upgrade);
            if (upgrade == Upgrade.MUFFLING) {
                this.tile.sendUpdatePacket();
            }
            this.tile.markForSave();
            return toAdd;
        }
        return 0;
    }

    public void removeUpgrade(Upgrade upgrade, boolean removeAll) {
        int toRemove;
        ItemStack simulatedRemainder;
        int installed = this.getUpgrades(upgrade);
        if (installed > 0 && (simulatedRemainder = this.upgradeOutputSlot.insertItem(UpgradeUtils.getStack(upgrade, toRemove = removeAll ? installed : 1), Action.SIMULATE, AutomationType.INTERNAL)).getCount() < toRemove) {
            if (installed == (toRemove -= simulatedRemainder.getCount())) {
                this.upgrades.remove(upgrade);
            } else {
                this.upgrades.put(upgrade, installed - toRemove);
            }
            this.tile.recalculateUpgrades(upgrade);
            this.upgradeOutputSlot.insertItem(UpgradeUtils.getStack(upgrade, toRemove), Action.EXECUTE, AutomationType.INTERNAL);
            this.canCheckUpgrades = !this.upgradeSlot.isEmpty();
        }
    }

    public boolean supports(Upgrade upgrade) {
        return this.supported.contains(upgrade);
    }

    public boolean isUpgradeInstalled(Upgrade upgrade) {
        return this.upgrades.containsKey(upgrade);
    }

    public Set<Upgrade> getInstalledTypes() {
        return this.upgrades.keySet();
    }

    @ComputerMethod(nameOverride="getSupportedUpgrades")
    public Set<Upgrade> getSupportedTypes() {
        return this.supported;
    }

    private List<IInventorySlot> getSlots() {
        return List.of(this.upgradeSlot, this.upgradeOutputSlot);
    }

    @Override
    public String getComponentKey() {
        return "component_upgrade";
    }

    @Override
    public void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        UpgradeAware upgradeAware = (UpgradeAware)input.get(MekanismDataComponents.UPGRADES);
        if (upgradeAware != null) {
            this.upgrades.clear();
            this.upgrades.putAll(upgradeAware.upgrades());
            this.upgradeSlot.setStack(upgradeAware.inputSlot());
            this.upgradeOutputSlot.setStack(upgradeAware.outputSlot());
        }
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(MekanismDataComponents.UPGRADES, (Object)new UpgradeAware(new EnumMap<Upgrade, Integer>(this.upgrades), this.upgradeSlot.getStack(), this.upgradeOutputSlot.getStack()));
    }

    @Override
    public void deserialize(CompoundTag upgradeNBT, HolderLookup.Provider provider) {
        this.upgrades.clear();
        this.upgrades.putAll(Upgrade.buildMap(upgradeNBT));
        for (Upgrade upgrade : this.getSupportedTypes()) {
            this.tile.recalculateUpgrades(upgrade);
        }
        ContainerType.ITEM.readFrom(provider, upgradeNBT, this.getSlots());
    }

    @Override
    public CompoundTag serialize(HolderLookup.Provider provider) {
        CompoundTag upgradeNBT = new CompoundTag();
        if (!this.upgrades.isEmpty()) {
            Upgrade.saveMap(this.upgrades, upgradeNBT);
        }
        ContainerType.ITEM.saveTo(provider, upgradeNBT, this.getSlots());
        return upgradeNBT;
    }

    @Override
    public void addToUpdateTag(CompoundTag updateTag) {
        if (this.supports(Upgrade.MUFFLING)) {
            updateTag.putInt("muffling", this.upgrades.getOrDefault(Upgrade.MUFFLING, 0).intValue());
        }
    }

    @Override
    public void readFromUpdateTag(CompoundTag updateTag) {
        if (this.supports(Upgrade.MUFFLING)) {
            NBTUtils.setIntIfPresent(updateTag, "muffling", amount -> {
                if (amount == 0) {
                    this.upgrades.remove(Upgrade.MUFFLING);
                } else {
                    this.upgrades.put(Upgrade.MUFFLING, amount);
                }
            });
        }
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        list.add(SyncableInt.create(() -> this.upgradeTicks, value -> {
            this.upgradeTicks = value;
        }));
        for (Upgrade upgrade : EnumUtils.UPGRADES) {
            if (!this.supports(upgrade)) continue;
            list.add(SyncableInt.create(() -> this.getUpgrades(upgrade), value -> {
                if (value == 0) {
                    this.upgrades.remove(upgrade);
                } else if (value > 0) {
                    this.upgrades.put(upgrade, value);
                }
            }));
        }
        return list;
    }
}

