/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.multiblock.container;

import com.folumo.mekanism_lasers.common.block_entity.EnergyStorageCellBlockEntity;
import com.folumo.mekanism_lasers.common.multiblock.data.energyStorageMultiblockData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Range;

@NothingNullByDefault
public class energyStorageMultiblockContainer
implements IEnergyContainer {
    private final Map<BlockPos, IEnergyContainer> cells = new Object2ObjectOpenHashMap();
    private long queuedOutput = 0L;
    private long queuedInput = 0L;
    private long lastOutput = 0L;
    private long lastInput = 0L;
    private long cachedTotal = 0L;
    private long transferCap = 0L;
    private long storageCap = 0L;
    private final energyStorageMultiblockData multiblock;

    public energyStorageMultiblockContainer(energyStorageMultiblockData multiblock) {
        this.multiblock = multiblock;
    }

    public void addCell(BlockPos pos, EnergyStorageCellBlockEntity cell) {
        MachineEnergyContainer<EnergyStorageCellBlockEntity> energyContainer = cell.getEnergyContainer();
        this.cells.put(pos, (IEnergyContainer)energyContainer);
        this.storageCap = MathUtils.addClamped((long)this.storageCap, (long)energyContainer.getMaxEnergy());
        this.cachedTotal = MathUtils.addClamped((long)this.cachedTotal, (long)energyContainer.getEnergy());
    }

    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEnergy() {
        return this.cachedTotal + this.queuedInput - this.queuedOutput;
    }

    public void setEnergy(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long energy) {
    }

    public long getMaxEnergy() {
        return this.storageCap;
    }

    private long getRemainingInput() {
        return this.transferCap - this.queuedInput;
    }

    private long getRemainingOutput() {
        return this.transferCap - this.queuedOutput;
    }

    public void onContentsChanged() {
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    public long insert(long amount, Action action, AutomationType automationType) {
        if (amount <= 0L || !this.multiblock.isFormed()) {
            return amount;
        }
        long toAdd = Math.min(Math.min(amount, this.getRemainingInput()), this.getNeeded());
        if (toAdd == 0L) {
            return amount;
        }
        if (action.execute()) {
            this.queuedInput += toAdd;
        }
        return amount - toAdd;
    }

    public long extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount <= 0L || !this.multiblock.isFormed()) {
            return 0L;
        }
        if ((amount = Math.min(Math.min(amount, this.getRemainingOutput()), this.getEnergy())) > 0L && action.execute()) {
            this.queuedOutput += amount;
        }
        return amount;
    }

    public void tick() {
        if (this.queuedInput < this.queuedOutput) {
            this.removeEnergy(this.queuedOutput - this.queuedInput);
        } else if (this.queuedInput > this.queuedOutput) {
            this.addEnergy(this.queuedInput - this.queuedOutput);
        }
        this.lastInput = this.queuedInput;
        this.lastOutput = this.queuedOutput;
        this.queuedInput = 0L;
        this.queuedOutput = 0L;
    }

    private void removeEnergy(long energy) {
        IEnergyContainer container;
        long extracted;
        this.cachedTotal -= energy;
        Iterator<IEnergyContainer> iterator = this.cells.values().iterator();
        while (iterator.hasNext() && ((extracted = (container = iterator.next()).extract(energy, Action.EXECUTE, AutomationType.INTERNAL)) <= 0L || (energy -= extracted) != 0L)) {
        }
    }

    private void addEnergy(long energy) {
        this.cachedTotal += energy;
        for (IEnergyContainer container : this.cells.values()) {
            long remainder = container.insert(energy, Action.EXECUTE, AutomationType.INTERNAL);
            if (remainder >= energy) continue;
            if (remainder == 0L) break;
            energy = remainder;
        }
    }
}

