/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.typeloader;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.Disassembly;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import com.mt1006.nbt_ac.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class TypeLoader {
    @Nullable
    public static volatile Thread objectCatcher = null;
    public static Object lastObject = null;

    public static void loadEntityTypes() {
        objectCatcher = Thread.currentThread();
        for (EntityType<?> entityType : RegistryUtils.ENTITY_TYPE) {
            Class clazz;
            lastObject = null;
            ResourceLocation resourceName = EntityType.getKey(entityType);
            if (resourceName.toString().equals("minecraft:player")) {
                clazz = ServerPlayer.class;
            } else {
                block8: {
                    try {
                        entityType.create(null);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof Error)) break block8;
                        NBTac.LOGGER.error("Entity \"{}\" constructor thrown error: {}", (Object)resourceName, (Object)throwable);
                    }
                }
                Class<Object> clazz2 = clazz = lastObject != null ? lastObject.getClass() : null;
            }
            if (clazz != null) {
                try {
                    NbtSuggestions suggestions = new NbtSuggestions(true);
                    Disassembly.disassemblyEntity(clazz, suggestions);
                    NbtSuggestionManager.add("entity/" + String.valueOf(resourceName), suggestions);
                }
                catch (Exception exception) {
                    NBTac.LOGGER.error("Failed to load entity \"{}\": {}", (Object)resourceName, (Object)exception);
                    Loader.printStackTrace(exception);
                }
                continue;
            }
            NBTac.LOGGER.error("Unable to get entity class for \"{}\"", (Object)resourceName);
        }
        objectCatcher = null;
    }

    public static void loadBlockEntityTypes() {
        objectCatcher = Thread.currentThread();
        boolean pistonCrashFix = NBTac.loaderInterface.isFabric() && Utils.isModPresent("moreculling") && Utils.isModPresent("modernfix") && Utils.isModPresent("lithium");
        for (BlockEntityType<?> blockEntityType : RegistryUtils.BLOCK_ENTITY_TYPE) {
            Class clazz;
            lastObject = null;
            ResourceLocation resourceName = BlockEntityType.getKey(blockEntityType);
            if (pistonCrashFix && blockEntityType == BlockEntityType.PISTON) {
                clazz = PistonMovingBlockEntity.class;
            } else {
                block8: {
                    try {
                        blockEntityType.create(BlockPos.ZERO, null);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof Error)) break block8;
                        NBTac.LOGGER.error("Block entity \"{}\" constructor thrown error: {}", (Object)resourceName, (Object)throwable);
                    }
                }
                Class<Object> clazz2 = clazz = lastObject != null ? lastObject.getClass() : null;
            }
            if (clazz != null) {
                try {
                    NbtSuggestions suggestions = new NbtSuggestions(true);
                    Disassembly.disassemblyBlockEntity(clazz, suggestions);
                    NbtSuggestionManager.add("block/" + String.valueOf(resourceName), suggestions);
                }
                catch (Exception exception) {
                    NBTac.LOGGER.error("Failed to load block entity \"{}\": {}", (Object)resourceName, (Object)exception);
                    Loader.printStackTrace(exception);
                }
                continue;
            }
            NBTac.LOGGER.error("Unable to get block entity class for \"{}\"", (Object)resourceName);
        }
        objectCatcher = null;
    }

    @Nullable
    public static BlockEntity blockEntityFromBlock(Block block) {
        block6: {
            if (!((Boolean)ModConfig.allowBlockEntityExtraction.val).booleanValue()) {
                return null;
            }
            ResourceLocation resLoc = RegistryUtils.BLOCK.getKey(block);
            if (resLoc == null) {
                return null;
            }
            BlockEntityType<?> blockEntityType = RegistryUtils.BLOCK_ENTITY_TYPE.get(resLoc);
            if (blockEntityType == null) {
                return null;
            }
            if (objectCatcher == Loader.getLoaderThread()) {
                return null;
            }
            objectCatcher = Thread.currentThread();
            lastObject = null;
            try {
                blockEntityType.create(BlockPos.ZERO, null);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof Error)) break block6;
                NBTac.LOGGER.error("Block entity \"{}\" constructor thrown error: {}", (Object)resLoc, (Object)throwable);
            }
        }
        objectCatcher = null;
        return lastObject instanceof BlockEntity ? (BlockEntity)lastObject : null;
    }
}

