/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.base;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.SerializationUtil;

public final class PersistentData {
    private static final Path saveFile = Paths.get("patchouli_data.json", new String[0]);
    public static DataHolder data = new DataHolder(new JsonObject());

    public static void setup() {
        try (BufferedReader r = Files.newBufferedReader(saveFile, Charsets.UTF_8);){
            JsonObject root = (JsonObject)SerializationUtil.RAW_GSON.fromJson((Reader)r, JsonObject.class);
            data = new DataHolder(root);
        }
        catch (IOException e) {
            if (!(e instanceof NoSuchFileException)) {
                PatchouliAPI.LOGGER.warn("Unable to load patchouli_data.json, replacing with default", (Throwable)e);
            }
            data = new DataHolder(new JsonObject());
            PersistentData.save();
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.warn("Corrupted patchouli_data.json, replacing with default", (Throwable)e);
            data = new DataHolder(new JsonObject());
            PersistentData.save();
        }
    }

    public static void save() {
        JsonObject json = data.serialize();
        try (BufferedWriter w = Files.newBufferedWriter(saveFile, Charsets.UTF_8, new OpenOption[0]);){
            SerializationUtil.PRETTY_GSON.toJson((JsonElement)json, (Appendable)w);
        }
        catch (IOException e) {
            PatchouliAPI.LOGGER.warn("Unable to save patchouli_data.json", (Throwable)e);
        }
    }

    public static final class DataHolder {
        public int bookGuiScale;
        public boolean clickedVisualize;
        private final Map<ResourceLocation, BookData> bookData = new HashMap<ResourceLocation, BookData>();

        public DataHolder(JsonObject root) {
            this.bookGuiScale = GsonHelper.getAsInt((JsonObject)root, (String)"bookGuiScale", (int)0);
            this.clickedVisualize = GsonHelper.getAsBoolean((JsonObject)root, (String)"clickedVisualize", (boolean)false);
            JsonObject obj = GsonHelper.getAsJsonObject((JsonObject)root, (String)"bookData", (JsonObject)new JsonObject());
            for (Map.Entry e : obj.entrySet()) {
                this.bookData.put(ResourceLocation.tryParse((String)((String)e.getKey())), new BookData(((JsonElement)e.getValue()).getAsJsonObject()));
            }
        }

        public BookData getBookData(Book book) {
            return this.bookData.computeIfAbsent(book.id, k -> new BookData(new JsonObject()));
        }

        public JsonObject serialize() {
            JsonObject ret = new JsonObject();
            ret.addProperty("bookGuiScale", (Number)this.bookGuiScale);
            ret.addProperty("clickedVisualize", Boolean.valueOf(this.clickedVisualize));
            JsonObject books = new JsonObject();
            for (Map.Entry<ResourceLocation, BookData> e : this.bookData.entrySet()) {
                books.add(e.getKey().toString(), (JsonElement)e.getValue().serialize());
            }
            ret.add("bookData", (JsonElement)books);
            return ret;
        }
    }

    public static final class BookData {
        public final List<ResourceLocation> viewedEntries = new ArrayList<ResourceLocation>();
        public final List<Bookmark> bookmarks = new ArrayList<Bookmark>();
        public final List<ResourceLocation> history = new ArrayList<ResourceLocation>();
        public final List<ResourceLocation> completedManualQuests = new ArrayList<ResourceLocation>();

        public BookData(JsonObject root) {
            JsonArray emptyArray = new JsonArray();
            for (JsonElement e : GsonHelper.getAsJsonArray((JsonObject)root, (String)"viewedEntries", (JsonArray)emptyArray)) {
                this.viewedEntries.add(ResourceLocation.tryParse((String)e.getAsString()));
            }
            for (JsonElement e : GsonHelper.getAsJsonArray((JsonObject)root, (String)"bookmarks", (JsonArray)emptyArray)) {
                this.bookmarks.add(new Bookmark(e.getAsJsonObject()));
            }
            for (JsonElement e : GsonHelper.getAsJsonArray((JsonObject)root, (String)"history", (JsonArray)emptyArray)) {
                this.history.add(ResourceLocation.tryParse((String)e.getAsString()));
            }
            for (JsonElement e : GsonHelper.getAsJsonArray((JsonObject)root, (String)"completedManualQuests", (JsonArray)emptyArray)) {
                this.completedManualQuests.add(ResourceLocation.tryParse((String)e.getAsString()));
            }
        }

        public JsonObject serialize() {
            JsonObject ret = new JsonObject();
            JsonArray viewed = new JsonArray();
            this.viewedEntries.stream().map(Object::toString).forEach(arg_0 -> ((JsonArray)viewed).add(arg_0));
            ret.add("viewedEntries", (JsonElement)viewed);
            JsonArray bookmarks = new JsonArray();
            this.bookmarks.stream().map(Bookmark::serialize).forEach(arg_0 -> ((JsonArray)bookmarks).add(arg_0));
            ret.add("bookmarks", (JsonElement)bookmarks);
            JsonArray completed = new JsonArray();
            this.completedManualQuests.stream().map(Object::toString).forEach(arg_0 -> ((JsonArray)completed).add(arg_0));
            ret.add("completedManualQuests", (JsonElement)completed);
            return ret;
        }
    }

    public static final class Bookmark {
        public final ResourceLocation entry;
        public final int spread;

        public Bookmark(ResourceLocation entry, int spread) {
            this.entry = entry;
            this.spread = spread;
        }

        public Bookmark(JsonObject root) {
            this.entry = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)root, (String)"entry"));
            this.spread = GsonHelper.getAsInt((JsonObject)root, (String)"page");
        }

        public BookEntry getEntry(Book book) {
            return book.getContents().entries.get(this.entry);
        }

        public JsonObject serialize() {
            JsonObject ret = new JsonObject();
            ret.addProperty("entry", this.entry.toString());
            ret.addProperty("page", (Number)this.spread);
            return ret;
        }
    }
}

