/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energycell;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.energycell.EnergyCellBlock;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;

public class EnergyCellTile
extends AbstractEnergyStorage<EnergyConfig, EnergyCellBlock>
implements IInventoryHolder {
    public EnergyCellTile(BlockPos pos, BlockState state, Tier tier) {
        super(Tiles.ENERGY_CELL.get(), pos, state, tier);
        this.inv.add(2);
    }

    public EnergyCellTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    protected void onFirstTick(Level world) {
        super.onFirstTick(world);
        if (this.isCreative()) {
            this.energy.setStored(this.getEnergyCapacity());
        }
    }

    @Override
    protected int postTick(Level world) {
        return this.chargeItems(2) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate, @Nullable Direction side) {
        return super.extractEnergy(maxExtract, simulate || this.isCreative(), side);
    }

    @Override
    public boolean canExtractEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canExtractEnergy(side);
    }

    @Override
    public boolean canReceiveEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canReceiveEnergy(side);
    }

    @Override
    public boolean keepEnergy() {
        return !this.isCreative();
    }

    @Override
    public Transfer getTransferType() {
        return this.isCreative() ? Transfer.EXTRACT : super.getTransferType();
    }

    public boolean isCreative() {
        return ((Tier)this.getVariant()).equals(Tier.CREATIVE);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

