/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public final class NSSFake
implements NormalizedSimpleStack {
    public static final MapCodec<NSSFake> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.optionalFieldOf("namespace").forGetter(nssFake -> IPECodecHelper.INSTANCE.ifNotEmpty(nssFake.namespace, String::isEmpty)), (App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("description").forGetter(nssFake -> nssFake.description)).apply((Applicative)instance, (namespace, description) -> namespace.map(n -> new NSSFake((String)n, (String)description)).orElseGet(() -> NSSFake.create(description))));
    private static String currentNamespace = "";
    private final String namespace;
    private final String description;
    private final int cachedHash;

    private NSSFake(String namespace, String description) {
        this.namespace = namespace;
        this.description = description;
        this.cachedHash = Objects.hashCode((Object[])new Object[]{this.namespace, this.description});
    }

    public static void resetNamespace() {
        NSSFake.setCurrentNamespace("");
    }

    public static void setCurrentNamespace(@NotNull String ns) {
        currentNamespace = ns;
    }

    @NotNull
    public static NSSFake create(String description) {
        if (description.isEmpty()) {
            throw new IllegalArgumentException("Description must not be empty");
        }
        return new NSSFake(currentNamespace, description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NSSFake)) return false;
        NSSFake fake = (NSSFake)o;
        if (!this.description.equals(fake.description)) return false;
        if (!this.namespace.equals(fake.namespace)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.cachedHash;
    }

    @Override
    public String toString() {
        return "NSSFake: " + this.namespace + "/" + this.description;
    }

    public MapCodec<NSSFake> codec() {
        return CODEC;
    }
}

