/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.world_transmutation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.SimpleWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.WorldTransmutation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.jetbrains.annotations.Nullable;

public record WorldTransmutationFile(@Nullable String comment, List<IWorldTransmutation> transmutations) {
    private static final Codec<IWorldTransmutation> TRANSMUTATION_CODEC = Codec.either(SimpleWorldTransmutation.CODEC, WorldTransmutation.CODEC).flatComapMap(Either::unwrap, transmutation -> {
        IWorldTransmutation iWorldTransmutation = transmutation;
        Objects.requireNonNull(iWorldTransmutation);
        IWorldTransmutation selector0$temp = iWorldTransmutation;
        int index$1 = 0;
        return DataResult.success((Object)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleWorldTransmutation.class, WorldTransmutation.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SimpleWorldTransmutation simple = (SimpleWorldTransmutation)selector0$temp;
                yield Either.left((Object)simple);
            }
            case 1 -> {
                WorldTransmutation worldTransmutation = (WorldTransmutation)selector0$temp;
                yield Either.right((Object)worldTransmutation);
            }
        }));
    });
    private static final Codec<List<IWorldTransmutation>> LIST_CODEC = TRANSMUTATION_CODEC.listOf();
    public static final Codec<WorldTransmutationFile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.optionalFieldOf("comment").forGetter(file -> Optional.ofNullable(file.comment())), (App)LIST_CODEC.optionalFieldOf("transmutations").forGetter(file -> IPECodecHelper.INSTANCE.ifNotEmpty(file.transmutations()))).apply((Applicative)instance, (comment, transmutations) -> new WorldTransmutationFile(comment.orElse(null), transmutations.orElseGet(Collections::emptyList))));
    public static final Codec<Optional<WithConditions<WorldTransmutationFile>>> CONDITIONAL_CODEC = ConditionalOps.createConditionalCodecWithConditions(CODEC);
}

