/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.arithmetic;

import java.math.BigInteger;
import moze_intel.projecte.api.mapper.arithmetic.IValueArithmetic;
import moze_intel.projecte.shaded.org.apache.commons.math3.fraction.BigFraction;
import moze_intel.projecte.utils.MathUtils;

public class FullBigFractionArithmetic
implements IValueArithmetic<BigFraction> {
    private static final BigInteger FREE_BIG_INT_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigFraction FREE_FRACTION_VALUE = new BigFraction(FREE_BIG_INT_VALUE);

    @Override
    public BigFraction getZero() {
        return BigFraction.ZERO;
    }

    @Override
    public boolean isZero(BigFraction value) {
        return value.getNumerator().signum() == 0;
    }

    @Override
    public boolean isLessThanZero(BigFraction value) {
        return value.getNumerator().signum() == -1;
    }

    @Override
    public boolean isLessThanEqualZero(BigFraction value) {
        return value.getNumerator().signum() != 1;
    }

    @Override
    public boolean isGreaterThanEqualZero(BigFraction value) {
        return value.getNumerator().signum() != -1;
    }

    @Override
    public boolean isGreaterThanZero(BigFraction value) {
        return value.getNumerator().signum() == 1;
    }

    @Override
    public BigFraction add(BigFraction a, BigFraction b) {
        if (this.isZero(a)) {
            return b;
        }
        if (this.isZero(b)) {
            return a;
        }
        if (this.isFree(a)) {
            return b;
        }
        if (this.isFree(b)) {
            return a;
        }
        return a.add(b);
    }

    @Override
    public BigFraction mul(long a, BigFraction b) {
        if (a == 1L || this.isZeroOrFree(b)) {
            return b;
        }
        return b.multiply(a);
    }

    @Override
    public BigFraction div(BigFraction a, long b) {
        if (b == 1L || this.isZeroOrFree(a)) {
            return a;
        }
        if (b == 0L) {
            return this.getZero();
        }
        BigFraction result = a.divide(b);
        if (MathUtils.isGreaterThanLong(result.getDenominator())) {
            return this.getZero();
        }
        return result;
    }

    @Override
    public BigFraction getFree() {
        return FREE_FRACTION_VALUE;
    }

    private boolean isZeroOrFree(BigFraction value) {
        if (value == this.getFree()) {
            return true;
        }
        int sign = value.getNumerator().signum();
        if (sign == 0) {
            return true;
        }
        if (sign == 1) {
            return false;
        }
        return value.getNumerator().equals(FREE_BIG_INT_VALUE);
    }

    @Override
    public boolean isFree(BigFraction value) {
        if (value == this.getFree()) {
            return true;
        }
        if (this.isGreaterThanEqualZero(value)) {
            return false;
        }
        return value.getNumerator().equals(FREE_BIG_INT_VALUE);
    }
}

