/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.generator;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.math.BigInteger;
import java.util.Map;
import moze_intel.projecte.api.mapper.generator.IValueGenerator;
import moze_intel.projecte.shaded.org.apache.commons.math3.fraction.BigFraction;
import moze_intel.projecte.utils.MathUtils;

public class BigFractionToLongGenerator<T>
implements IValueGenerator<T, Long> {
    private final IValueGenerator<T, BigFraction> inner;

    public BigFractionToLongGenerator(IValueGenerator<T, BigFraction> inner) {
        this.inner = inner;
    }

    public Object2LongMap<T> generateValues() {
        Map<T, BigFraction> innerResult = this.inner.generateValues();
        Object2LongOpenHashMap myResult = new Object2LongOpenHashMap();
        for (Map.Entry<T, BigFraction> entry : innerResult.entrySet()) {
            BigInteger bigInt;
            T key = entry.getKey();
            BigFraction value = entry.getValue();
            BigInteger numerator = value.getNumerator();
            if (numerator.signum() != 1 || (bigInt = numerator.divide(value.getDenominator())).signum() != 1) continue;
            int compare = bigInt.compareTo(MathUtils.MAX_LONG);
            if (compare == 0) {
                myResult.put(key, Long.MAX_VALUE);
                continue;
            }
            if (compare >= 0) continue;
            myResult.put(key, bigInt.longValue());
        }
        return myResult;
    }
}

