/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.utils.AnnotationHelper;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.ModConfigSpec;

@EMCMapper
public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private final Map<String, BooleanSupplier> enabledRecipeMappers = new HashMap<String, BooleanSupplier>();
    private final List<IRecipeTypeMapper> recipeMappers = AnnotationHelper.getRecipeTypeMappers();

    private boolean isRecipeMapperEnabled(IRecipeTypeMapper mapper) {
        BooleanSupplier supplier = this.enabledRecipeMappers.get(mapper.getName());
        return supplier == null || supplier.getAsBoolean();
    }

    @Override
    public void addConfigOptions(ModConfigSpec.Builder configBuilder) {
        for (IRecipeTypeMapper recipeMapper : this.recipeMappers) {
            configBuilder.comment(recipeMapper.getDescription()).translation(recipeMapper.getTranslationKey()).push(recipeMapper.getConfigPath());
            this.enabledRecipeMappers.put(recipeMapper.getName(), (BooleanSupplier)PEConfigTranslations.MAPPING_RECIPE_TYPE_MAPPER_ENABLED.applyToBuilder(configBuilder).define("enabled", recipeMapper.isAvailable()));
            recipeMapper.addConfigOptions(configBuilder);
            configBuilder.pop();
        }
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        NSSFake.setCurrentNamespace("craftingMapper");
        Reference2ObjectOpenHashMap recipeCount = new Reference2ObjectOpenHashMap();
        ReferenceOpenHashSet canNotMap = new ReferenceOpenHashSet();
        RecipeManager recipeManager = serverResources.getRecipeManager();
        NSSFakeGroupManager fakeGroupManager = new NSSFakeGroupManager(mapper);
        for (Map.Entry entry : BuiltInRegistries.RECIPE_TYPE.entrySet()) {
            ResourceKey typeRegistryKey = (ResourceKey)entry.getKey();
            RecipeType recipeType = (RecipeType)entry.getValue();
            boolean wasHandled = false;
            ArrayList recipes = null;
            ArrayList<Object> unhandled = new ArrayList();
            for (IRecipeTypeMapper recipeMapper : this.recipeMappers) {
                if (!this.isRecipeMapperEnabled(recipeMapper) || !recipeMapper.canHandle(recipeType)) continue;
                if (recipes == null) {
                    recipes = recipeManager.getAllRecipesFor(recipeType);
                }
                int numHandled = 0;
                for (RecipeHolder recipeHolder : recipes) {
                    try {
                        if (recipeMapper.handleRecipe(mapper, recipeHolder, registryAccess, fakeGroupManager)) {
                            ++numHandled;
                            continue;
                        }
                        unhandled.add(recipeHolder);
                    }
                    catch (Exception e) {
                        PECore.LOGGER.error(LogUtils.FATAL_MARKER, "A fatal error occurred while trying to map the recipe: {}", (Object)recipeHolder.id());
                        throw e;
                    }
                }
                if (numHandled <= 0 && !recipes.isEmpty()) continue;
                RecipeCountInfo recipeCountInfo = (RecipeCountInfo)recipeCount.get((Object)typeRegistryKey);
                if (recipeCountInfo != null) {
                    recipeCountInfo.setUnhandled(unhandled);
                } else {
                    recipeCount.put((Object)typeRegistryKey, (Object)new RecipeCountInfo(recipes.size(), unhandled));
                }
                wasHandled = true;
                if (unhandled.isEmpty()) break;
                recipes = unhandled;
                unhandled = new ArrayList();
            }
            if (wasHandled) continue;
            canNotMap.add(typeRegistryKey);
        }
        PECore.debugLog("{} Statistics:", this.getName());
        ObjectIterator iterator = Reference2ObjectMaps.fastIterator((Reference2ObjectMap)recipeCount);
        while (iterator.hasNext()) {
            Map.Entry entry;
            entry = (Reference2ObjectMap.Entry)iterator.next();
            ResourceLocation typeRegistryName = ((ResourceKey)entry.getKey()).location();
            RecipeCountInfo countInfo = (RecipeCountInfo)entry.getValue();
            int total = countInfo.getTotalRecipes();
            List<RecipeHolder<?>> unhandled = countInfo.getUnhandled();
            PECore.debugLog("Found and handled {} of {} Recipes of Type {}", total - unhandled.size(), total, typeRegistryName);
            if (unhandled.isEmpty()) continue;
            PECore.debugLog("Unhandled Recipes of Type {}:", typeRegistryName);
            for (RecipeHolder<?> recipeHolder : unhandled) {
                PECore.debugLog("Name: {}, Recipe class: {}", recipeHolder.id(), recipeHolder.value().getClass().getName());
            }
        }
        for (ResourceKey typeRegistryKey : canNotMap) {
            PECore.debugLog("Could not map any Recipes of Type: {}", typeRegistryKey.location());
        }
        NSSFake.resetNamespace();
    }

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER.tooltip();
    }

    private static class NSSFakeGroupManager
    implements INSSFakeGroupManager {
        private static final Function<Object2IntMap<NormalizedSimpleStack>, String> MAP_DESCRIPTOR = map -> map.object2IntEntrySet().stream().map(entry -> String.valueOf(entry.getKey()) + ":" + entry.getIntValue()).collect(Collectors.joining(", "));
        private static final boolean DEBUG_GROUP_CONTENTS = false;
        private final Map<Object2IntMap<NormalizedSimpleStack>, INSSFakeGroupManager.FakeGroupData> ingredientGroupsWithCount = new HashMap<Object2IntMap<NormalizedSimpleStack>, INSSFakeGroupManager.FakeGroupData>();
        private final Map<Object2IntMap<NormalizedSimpleStack>, INSSFakeGroupManager.FakeGroupData> groupsWithCount = new HashMap<Object2IntMap<NormalizedSimpleStack>, INSSFakeGroupManager.FakeGroupData>();
        private final IMappingCollector<NormalizedSimpleStack, Long> mapper;
        private int fakeIndex;

        public NSSFakeGroupManager(IMappingCollector<NormalizedSimpleStack, Long> mapper) {
            this.mapper = mapper;
        }

        @Override
        public INSSFakeGroupManager.FakeGroupData getOrCreateFakeGroup(Object2IntMap<NormalizedSimpleStack> normalizedSimpleStacks, boolean representsIngredient, boolean skipConversions) {
            return this.getOrCreateFakeGroup(normalizedSimpleStacks, representsIngredient, skipConversions, Object2IntOpenHashMap::new);
        }

        @Override
        public INSSFakeGroupManager.FakeGroupData getOrCreateFakeGroupDirect(Object2IntMap<NormalizedSimpleStack> normalizedSimpleStacks, boolean representsIngredient, boolean skipConversions) {
            return this.getOrCreateFakeGroup(normalizedSimpleStacks, representsIngredient, skipConversions, UnaryOperator.identity());
        }

        private INSSFakeGroupManager.FakeGroupData getOrCreateFakeGroup(Object2IntMap<NormalizedSimpleStack> stacks, boolean representsIngredient, boolean skipConversions, UnaryOperator<Object2IntMap<NormalizedSimpleStack>> copyFunction) {
            Map<Object2IntMap<NormalizedSimpleStack>, INSSFakeGroupManager.FakeGroupData> groups = representsIngredient ? this.ingredientGroupsWithCount : this.groupsWithCount;
            INSSFakeGroupManager.FakeGroupData data = groups.get(stacks);
            if (data == null) {
                String description = Integer.toString(this.fakeIndex++);
                NSSFake dummy = NSSFake.create(description);
                groups.put((Object2IntMap<NormalizedSimpleStack>)((Object2IntMap)copyFunction.apply(stacks)), new INSSFakeGroupManager.FakeGroupData(dummy, false));
                if (!skipConversions) {
                    if (representsIngredient) {
                        ObjectIterator iterator = Object2IntMaps.fastIterator(stacks);
                        while (iterator.hasNext()) {
                            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                            this.mapper.addConversion(1, (NormalizedSimpleStack)dummy, EMCHelper.intMapOf((NormalizedSimpleStack)entry.getKey(), entry.getIntValue()));
                        }
                    } else {
                        this.mapper.addConversion(1, (NormalizedSimpleStack)dummy, stacks);
                    }
                }
                return new INSSFakeGroupManager.FakeGroupData(dummy, true);
            }
            return data;
        }
    }

    private static class RecipeCountInfo {
        private final int totalRecipes;
        private List<RecipeHolder<?>> unhandled;

        private RecipeCountInfo(int totalRecipes, List<RecipeHolder<?>> unhandled) {
            this.totalRecipes = totalRecipes;
            this.unhandled = unhandled;
        }

        public int getTotalRecipes() {
            return this.totalRecipes;
        }

        public void setUnhandled(List<RecipeHolder<?>> unhandled) {
            this.unhandled = unhandled;
        }

        public List<RecipeHolder<?>> getUnhandled() {
            return this.unhandled;
        }
    }
}

