/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMPedestalBlockEntity
extends EmcBlockEntity
implements IDMPedestal {
    public static final ICapabilityProvider<DMPedestalBlockEntity, @Nullable Direction, IItemHandler> INVENTORY_PROVIDER = (pedestal, side) -> pedestal.inventory;
    private static final int RANGE = 4;
    private final EmcBlockEntity.StackHandler inventory = new EmcBlockEntity.StackHandler(1){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (DMPedestalBlockEntity.this.level != null && !((DMPedestalBlockEntity)DMPedestalBlockEntity.this).level.isClientSide) {
                BlockState state = DMPedestalBlockEntity.this.getBlockState();
                DMPedestalBlockEntity.this.level.sendBlockUpdated(DMPedestalBlockEntity.this.worldPosition, state, state, 8);
            }
        }
    };
    private boolean isActive = false;
    private int particleCooldown = 10;
    private int activityCooldown = 0;
    public boolean previousRedstoneState = false;

    public DMPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(PEBlockEntityTypes.DARK_MATTER_PEDESTAL, pos, state, 1000L);
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, DMPedestalBlockEntity pedestal) {
        if (pedestal.getActive()) {
            ItemStack stack = pedestal.inventory.getStackInSlot(0);
            IPedestalItem pedestalItem = (IPedestalItem)stack.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY);
            if (pedestalItem == null) {
                pedestal.setActive(level, pos, false);
            } else {
                pedestalItem.updateInPedestal(stack, level, pos, pedestal);
                if (pedestal.particleCooldown <= 0) {
                    DMPedestalBlockEntity.spawnParticleTypes(level, pos);
                    pedestal.particleCooldown = 10;
                } else {
                    --pedestal.particleCooldown;
                }
            }
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, DMPedestalBlockEntity pedestal) {
        if (pedestal.getActive()) {
            ItemStack stack = pedestal.inventory.getStackInSlot(0);
            IPedestalItem pedestalItem = (IPedestalItem)stack.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY);
            if (pedestalItem == null) {
                pedestal.setActive(level, pos, false);
            } else if (pedestalItem.updateInPedestal(stack, level, pos, pedestal)) {
                pedestal.inventory.onContentsChanged(0);
            }
        }
        pedestal.updateComparators(level, pos);
    }

    private static void spawnParticleTypes(@NotNull Level level, @NotNull BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.2, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.2, (double)y + 0.3, (double)z + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.2, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.8, (double)y + 0.3, (double)z + 0.2, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.8, (double)y + 0.3, (double)z + 0.5, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x + 0.8, (double)y + 0.3, (double)z + 0.8, 0.0, 0.0, 0.0);
        RandomSource rand = level.random;
        for (int i = 0; i < 3; ++i) {
            int xDirection = rand.nextBoolean() ? -1 : 1;
            int zDirection = rand.nextBoolean() ? -1 : 1;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)x + 0.5 + (double)xDirection * 0.25, (double)((float)y + rand.nextFloat()), (double)z + 0.5 + (double)zDirection * 0.25, (double)((float)xDirection * rand.nextFloat()), ((double)rand.nextFloat() - 0.5) * 0.125, (double)((float)zDirection * rand.nextFloat()));
        }
    }

    @Override
    public int getActivityCooldown() {
        return this.activityCooldown;
    }

    @Override
    public void setActivityCooldown(@NotNull Level level, @NotNull BlockPos pos, int cooldown) {
        if (this.activityCooldown != cooldown) {
            this.activityCooldown = cooldown;
            this.markDirty(level, pos, false);
        }
    }

    @Override
    public void decrementActivityCooldown(@NotNull Level level, @NotNull BlockPos pos) {
        --this.activityCooldown;
        this.markDirty(level, pos, false);
    }

    @Override
    public AABB getEffectBounds() {
        return new AABB(this.worldPosition).inflate(4.0);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag);
        this.isActive = tag.getBoolean("active");
        this.activityCooldown = tag.getInt("activity_cooldown");
        this.previousRedstoneState = tag.getBoolean("powered");
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.merge(this.inventory.serializeNBT(registries));
        tag.putBoolean("active", this.getActive());
        tag.putInt("activity_cooldown", this.activityCooldown);
        tag.putBoolean("powered", this.previousRedstoneState);
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void setActive(@NotNull Level level, @NotNull BlockPos pos, boolean newState) {
        if (newState != this.getActive()) {
            if (newState) {
                level.playSound(null, pos, (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < level.random.nextInt(35) + 10; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() + 0.5 + level.random.nextGaussian() * (double)0.13f, (double)(pos.getY() + 1) + level.random.nextGaussian() * (double)0.13f, (double)pos.getZ() + 0.5 + level.random.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
                }
            } else {
                level.playSound(null, pos, (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < level.random.nextInt(35) + 10; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + level.random.nextGaussian() * (double)0.13f, (double)(pos.getY() + 1) + level.random.nextGaussian() * (double)0.13f, (double)pos.getZ() + 0.5 + level.random.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
                }
            }
        }
        this.isActive = newState;
        this.markDirty(level, pos, true);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }
}

