/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.Objects;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.container.slots.ComponentSlotGhost;
import moze_intel.projecte.gameObjs.container.slots.ISlotGhost;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerCopySlot;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MercurialEyeContainer
extends PEHandContainer {
    private final ComponentSlotGhost mercurialTarget;

    public static MercurialEyeContainer fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf buf) {
        return new MercurialEyeContainer(windowId, playerInv, (InteractionHand)buf.readEnum(InteractionHand.class), buf.readByte());
    }

    public MercurialEyeContainer(int windowId, Inventory playerInv, InteractionHand hand, int selected) {
        super(PEContainerTypes.MERCURIAL_EYE_CONTAINER, windowId, playerInv, hand, selected);
        IItemHandler handler = Objects.requireNonNull((IItemHandler)this.stack.getCapability(Capabilities.ItemHandler.ITEM));
        this.addSlot((Slot)new InventoryContainerCopySlot(handler, 0, 50, 26));
        this.mercurialTarget = new ComponentSlotGhost(handler, 1, 104, 26);
        this.addSlot((Slot)this.mercurialTarget);
        this.addPlayerInventory(6, 56);
    }

    @Override
    public void clickPostValidate(int slotId, int button, @NotNull ClickType flag, @NotNull Player player) {
        ISlotGhost ghost;
        Slot slot = this.tryGetSlot(slotId);
        if (!(slot instanceof ISlotGhost) || !(ghost = (ISlotGhost)slot).tryClear()) {
            super.clickPostValidate(slotId, button, flag, player);
        }
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotID) {
        if (slotID > 1 && !this.mercurialTarget.hasItem()) {
            Slot currentSlot = this.tryGetSlot(slotID);
            if (currentSlot == null || !currentSlot.hasItem()) {
                return ItemStack.EMPTY;
            }
            ItemStack slotStack = currentSlot.getItem();
            if (!slotStack.isEmpty() && this.mercurialTarget.mayPlace(slotStack)) {
                return ItemStack.EMPTY;
            }
        }
        return super.quickMoveStack(player, slotID);
    }
}

