/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityFireProjectile;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.entity.NoGravityThrowableProjectile;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.integration.curios.IExposesCurioAttributes;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;

public class Arcana
extends ItemPE
implements IItemMode<ArcanaMode>,
IFireProtector,
IExtraFunction,
IProjectileShooter,
ICapabilityAware,
IExposesCurioAttributes {
    private static final AttributeModifier FLIGHT = new AttributeModifier(PECore.rl("arcana_flight"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private final Supplier<ItemAttributeModifiers> defaultModifiers = Suppliers.memoize(() -> ItemAttributeModifiers.builder().add(NeoForgeMod.CREATIVE_FLIGHT, FLIGHT, EquipmentSlotGroup.ANY).build());

    public Arcana(Item.Properties props) {
        super(props.component(PEDataComponentTypes.ACTIVE, (Object)false).component(PEDataComponentTypes.ARCANA_MODE, (Object)ArcanaMode.ZERO).component(PEDataComponentTypes.STORED_EMC, (Object)0L));
    }

    @Deprecated
    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    @Override
    public void addAttributes(Multimap<Holder<Attribute>, AttributeModifier> attributes) {
        attributes.put((Object)NeoForgeMod.CREATIVE_FLIGHT, (Object)FLIGHT);
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.copy();
    }

    private void tick(ItemStack stack, Level level, ServerPlayer player) {
        if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            switch (((ArcanaMode)this.getMode(stack)).ordinal()) {
                case 0: {
                    WorldHelper.freezeInBoundingBox(level, player.getBoundingBox().inflate(5.0), (Player)player, true);
                    break;
                }
                case 1: {
                    WorldHelper.igniteNearby(level, (Player)player);
                    break;
                }
                case 2: {
                    WorldHelper.growNearbyRandomly(true, level, (Player)player);
                    break;
                }
                case 3: {
                    WorldHelper.repelEntitiesSWRG(level, player.getBoundingBox().inflate(5.0), (Player)player);
                }
            }
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (!level.isClientSide && Arcana.hotBarOrOffHand(slot) && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.tick(stack, level, player);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            tooltip.add(this.getToolTip(stack));
        } else {
            tooltip.add((Component)PELang.TOOLTIP_ARCANA_INACTIVE.translateColored(ChatFormatting.RED));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            stack.update(PEDataComponentTypes.ACTIVE, (Object)false, active -> active == false);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        InteractionResult result;
        if (this.getMode(ctx.getItemInHand()) == ArcanaMode.IGNITION && (result = WorldHelper.igniteBlock(ctx)) != InteractionResult.PASS) {
            return result;
        }
        return super.useOn(ctx);
    }

    @Override
    public boolean doExtraFunction(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        Level level = player.level();
        if (level.isClientSide) {
            return true;
        }
        if (this.getMode(stack) == ArcanaMode.IGNITION) {
            switch (player.getDirection()) {
                case SOUTH: 
                case NORTH: {
                    this.igniteNear(player, level, 30, 5, 3);
                    break;
                }
                case WEST: 
                case EAST: {
                    this.igniteNear(player, level, 3, 5, 30);
                }
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    private void igniteNear(Player player, Level level, int xOffset, int yOffset, int zOffset) {
        for (BlockPos pos : WorldHelper.getPositionsInBox(player.getBoundingBox().inflate((double)xOffset, (double)yOffset, (double)zOffset))) {
            if (!level.isEmptyBlock(pos)) continue;
            PlayerHelper.checkedPlaceBlock(player, level, pos.immutable(), Blocks.FIRE.defaultBlockState());
        }
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        EntitySWRGProjectile projectile;
        Level level = player.level();
        if (level.isClientSide) {
            return false;
        }
        SoundEvent sound = null;
        switch (((ArcanaMode)this.getMode(stack)).ordinal()) {
            case 0: {
                sound = SoundEvents.SNOWBALL_THROW;
                NoGravityThrowableProjectile noGravityThrowableProjectile = new Snowball(level, (LivingEntity)player);
                break;
            }
            case 1: {
                sound = (SoundEvent)PESoundEvents.POWER.get();
                NoGravityThrowableProjectile noGravityThrowableProjectile = new EntityFireProjectile(player, true, level);
                break;
            }
            case 3: {
                NoGravityThrowableProjectile noGravityThrowableProjectile = new EntitySWRGProjectile(player, true, level);
                break;
            }
            default: {
                NoGravityThrowableProjectile noGravityThrowableProjectile = projectile = null;
            }
        }
        if (projectile == null) {
            return false;
        }
        projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)projectile);
        if (sound != null) {
            projectile.playSound(sound, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        return true;
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility action) {
        if (action == ItemAbilities.FIRESTARTER_LIGHT && this.getMode(stack) == ArcanaMode.IGNITION) {
            return true;
        }
        return super.canPerformAction(stack, action);
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }

    @Override
    public DataComponentType<ArcanaMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.ARCANA_MODE.get();
    }

    @Override
    public ArcanaMode getDefaultMode() {
        return ArcanaMode.ZERO;
    }

    public static enum ArcanaMode implements IModeEnum<ArcanaMode>
    {
        ZERO(PELang.MODE_ARCANA_1),
        IGNITION(PELang.MODE_ARCANA_2),
        HARVEST(PELang.MODE_ARCANA_3),
        SWRG(PELang.MODE_ARCANA_4);

        public static final Codec<ArcanaMode> CODEC;
        public static final IntFunction<ArcanaMode> BY_ID;
        public static final StreamCodec<ByteBuf, ArcanaMode> STREAM_CODEC;
        private final IHasTranslationKey langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        private ArcanaMode(IHasTranslationKey langEntry) {
            this.langEntry = langEntry;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public ArcanaMode next(ItemStack stack) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> IGNITION;
                case 1 -> HARVEST;
                case 2 -> SWRG;
                case 3 -> ZERO;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(ArcanaMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ArcanaMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

