/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.integration.crafttweaker.mappers.CrTConversionEMCMapper;

public class CustomConversionAction
implements IUndoableAction {
    private final CrTConversionEMCMapper.CrTConversion conversion;

    public CustomConversionAction(NormalizedSimpleStack output, int amount, boolean propagateTags, boolean set, Map<NormalizedSimpleStack, Integer> ingredients) {
        this.conversion = new CrTConversionEMCMapper.CrTConversion(output, amount, propagateTags, set, (Object2IntMap<NormalizedSimpleStack>)new Object2IntArrayMap(ingredients));
    }

    public void apply() {
        CrTConversionEMCMapper.addConversion(this.conversion);
    }

    public String describe() {
        StringBuilder inputString = new StringBuilder();
        ObjectIterator iterator = Object2IntMaps.fastIterator(this.conversion.ingredients());
        while (iterator.hasNext()) {
            int amount;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            if (!inputString.isEmpty()) {
                inputString.append(", ");
            }
            if ((amount = entry.getIntValue()) > 1) {
                inputString.append(amount).append(" ");
            }
            inputString.append(entry.getKey());
        }
        String description = "Added custom conversion creating '" + this.conversion.amount() + "' of " + String.valueOf(this.conversion.output()) + ", from: " + String.valueOf(inputString);
        if (this.conversion.propagateTags() && this.conversion.output() instanceof NSSTag) {
            description = description + "; propagating to elements of " + String.valueOf(this.conversion.output());
        }
        return description;
    }

    public void undo() {
        CrTConversionEMCMapper.removeConversion(this.conversion);
    }

    public String describeUndo() {
        return "Undoing adding of custom conversion creating '" + this.conversion.amount() + "' of " + String.valueOf(this.conversion.output());
    }

    public String systemName() {
        return "ProjectE";
    }
}

